/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="compress-resources")
public class CompressResourcesMojo
extends AbstractAmpsMojo {
    @Parameter(defaultValue="true")
    private boolean compressResources;
    @Parameter(defaultValue="true")
    private boolean compressJs;
    @Parameter(defaultValue="true")
    private boolean compressCss;
    @Parameter
    private Map<String, String> closureOptions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.compressResources) {
            Charset cs;
            if (this.encoding == null) {
                cs = Charset.defaultCharset();
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + cs.name() + ", i.e. build is platform dependent!"));
            } else {
                try {
                    cs = Charset.forName(this.encoding);
                }
                catch (IllegalCharsetNameException ex) {
                    throw new MojoExecutionException("Failed to resolve charset: " + this.encoding, (Exception)ex);
                }
                catch (UnsupportedCharsetException ex) {
                    throw new MojoExecutionException("Failed to resolve charset: " + this.encoding, (Exception)ex);
                }
            }
            this.getMavenGoals().compressResources(this.compressJs, this.compressCss, this.closureJsCompiler, cs, this.closureOptions);
        } else {
            this.getLog().debug((CharSequence)"Compressing resources disabled");
        }
    }
}

