/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.LibArtifact;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.RunMojo;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseType;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="pre-integration-test", requiresDependencyResolution=ResolutionScope.TEST)
public class PreIntegrationTestMojo
extends RunMojo {
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean testsSkip;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.testsSkip || this.skipTests) {
            this.getLog().info((CharSequence)"Pre integration tests skipped");
            return;
        }
        MavenGoals goals = this.getMavenGoals();
        List<ProductExecution> productExecutions = this.getProductExecutions();
        if (null != productExecutions) {
            block4: for (ProductExecution productExecution : productExecutions) {
                if (!"jira".equals(productExecution.getProduct().getId())) continue;
                List<DataSource> dataSources = productExecution.getProduct().getDataSources();
                switch (dataSources.size()) {
                    case 1: {
                        DataSource dataSource = dataSources.get(0);
                        JiraDatabaseType databaseType = JiraDatabaseType.getDatabaseType(dataSource.getUrl(), dataSource.getDriver());
                        if (null == databaseType) {
                            throw new MojoExecutionException("Could not detect database type, please check your database driver: " + dataSource.getDriver() + " and database url: " + dataSource.getUrl());
                        }
                        if (null == productExecution.getProduct().getLibArtifacts() || productExecution.getProduct().getLibArtifacts().size() == 0) {
                            throw new MojoExecutionException("Product library artifact is empty, please provide library for database: " + databaseType.toString());
                        }
                        for (ProductArtifact productArtifact : productExecution.getProduct().getLibArtifacts()) {
                            dataSource.getLibArtifacts().add(new LibArtifact(productArtifact.getGroupId(), productArtifact.getArtifactId(), productArtifact.getVersion()));
                        }
                        goals.runPreIntegrationTest(dataSource);
                        continue block4;
                    }
                    case 0: {
                        this.getLog().info((CharSequence)"Missing configuration dataSource for pre-integration-test");
                    }
                }
                this.getLog().info((CharSequence)("Multiple dataSources does not support. Configuration has: " + dataSources.size() + " dataSources below"));
                for (DataSource dbSource : dataSources) {
                    this.getLog().info((CharSequence)("Database URL: " + dbSource.getUrl()));
                }
                this.getLog().info((CharSequence)"Could not support multiple dataSource");
            }
        }
    }
}

