/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util.ant;

import com.atlassian.maven.plugins.amps.util.ant.AntBuildListener;
import com.atlassian.maven.plugins.amps.util.ant.AntUtils;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Java;

public class JavaTaskFactory {
    private final AntUtils antUtils = new AntUtils();
    private final Log logger;

    public JavaTaskFactory(Log logger) {
        this.logger = logger;
    }

    public Java newJavaTask() {
        return this.newJavaTask(new Parameters(null, null, Collections.emptyMap()));
    }

    public Java newJavaTask(Parameters params) {
        Java java = (Java)this.antUtils.createAntTask("java");
        java.setFork(true);
        this.setOutput(params.output, java);
        this.addBuildListener(java);
        this.addSystemProperties(java, params.systemProperties);
        this.addJvmArgs(java, params.jvmArgs);
        return java;
    }

    private void setOutput(String output, Java java) {
        if (output != null) {
            File outputFile = new File(output);
            outputFile.getAbsoluteFile().getParentFile().mkdirs();
            java.setOutput(outputFile);
            java.setAppend(true);
        }
    }

    private void addBuildListener(Java java) {
        boolean foundBuildListener = false;
        for (Object listenerObject : java.getProject().getBuildListeners()) {
            if (!(listenerObject instanceof AntBuildListener)) continue;
            foundBuildListener = true;
            break;
        }
        if (!foundBuildListener) {
            java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.logger));
        }
    }

    private void addSystemProperties(Java java, Map<String, String> systemProperties) {
        for (Map.Entry<String, String> prop : systemProperties.entrySet()) {
            java.addSysproperty(this.antUtils.createSysProperty(prop.getKey(), prop.getValue()));
        }
    }

    private void addJvmArgs(Java java, String jvmArgs) {
        if (jvmArgs != null) {
            java.createJvmarg().setLine(jvmArgs);
        }
    }

    public static Parameters output(String output) {
        return new Parameters(output, null, null);
    }

    public static Parameters jvmArgs(String jvmArgs) {
        return new Parameters(null, jvmArgs, null);
    }

    public static Parameters systemProperties(Map<String, String> systemProperties) {
        return new Parameters(null, null, systemProperties);
    }

    public static final class Parameters {
        private final String jvmArgs;
        private final Map<String, String> systemProperties;
        private final String output;

        private Parameters(String output, String jvmArgs, Map<String, String> systemProperties) {
            this.output = output;
            this.jvmArgs = jvmArgs;
            this.systemProperties = systemProperties;
        }

        public Parameters output(String output) {
            return new Parameters(output, this.jvmArgs, this.systemProperties);
        }

        public Parameters jvmArgs(String jvmArgs) {
            return new Parameters(this.output, jvmArgs, this.systemProperties);
        }

        public Parameters systemProperties(Map<String, String> systemProperties) {
            return new Parameters(this.output, this.jvmArgs, systemProperties);
        }
    }
}

