/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util.minifier;

import com.atlassian.maven.plugins.amps.util.minifier.GoogleClosureJSMinifier;
import com.atlassian.maven.plugins.amps.util.minifier.YUIErrorReporter;
import com.googlecode.htmlcompressor.compressor.XmlCompressor;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.mozilla.javascript.ErrorReporter;

public class ResourcesMinifier {
    private static ResourcesMinifier INSTANCE;

    private ResourcesMinifier() {
    }

    public static void minify(List<Resource> resources, File outputDir, boolean compressJs, boolean compressCss, boolean useClosureForJs, Charset cs, Log log, Map<String, String> closureOptions) throws MojoExecutionException {
        GoogleClosureJSMinifier.setOptions(closureOptions, log);
        if (null == INSTANCE) {
            INSTANCE = new ResourcesMinifier();
        }
        for (Resource resource : resources) {
            INSTANCE.processResource(resource, outputDir, compressJs, compressCss, useClosureForJs, cs, log);
        }
    }

    public void processResource(Resource resource, File outputDir, boolean compressJs, boolean compressCss, boolean useClosureForJs, Charset cs, Log log) throws MojoExecutionException {
        File resourceDir;
        File destDir = outputDir;
        if (StringUtils.isNotBlank((String)resource.getTargetPath())) {
            destDir = new File(outputDir, resource.getTargetPath());
        }
        if (null == (resourceDir = new File(resource.getDirectory())) || !resourceDir.exists()) {
            return;
        }
        if (compressJs) {
            this.processJs(resourceDir, destDir, resource.getIncludes(), resource.getExcludes(), useClosureForJs, cs, log);
        }
        if (compressCss) {
            this.processCss(resourceDir, destDir, resource.getIncludes(), resource.getExcludes(), cs, log);
        }
        this.processXml(resourceDir, destDir, resource.getIncludes(), resource.getExcludes(), cs, log);
    }

    public void processXml(File resourceDir, File destDir, List<String> includes, List<String> excludes, Charset cs, Log log) throws MojoExecutionException {
        log.info((CharSequence)"Compressing XML files");
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resourceDir);
        if (null == includes || includes.isEmpty()) {
            includes = Collections.singletonList("**/*.xml");
        }
        scanner.setIncludes(includes.toArray(new String[includes.size()]));
        if (null != excludes && !excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        XmlCompressor compressor = new XmlCompressor();
        int numberOfMinifiedFile = 0;
        for (String name : scanner.getIncludedFiles()) {
            File sourceFile = new File(resourceDir, name);
            if (!sourceFile.getName().endsWith(".xml")) continue;
            File destFile = new File(destDir, name);
            if (!sourceFile.exists() || !sourceFile.canRead()) continue;
            if (destFile.exists() && destFile.lastModified() > sourceFile.lastModified()) {
                log.debug((CharSequence)("Nothing to do, " + destFile.getAbsolutePath() + " is younger than the original"));
                continue;
            }
            log.debug((CharSequence)("compressing to " + destFile.getAbsolutePath()));
            try {
                FileUtils.forceMkdir((File)destFile.getParentFile());
                String source = FileUtils.readFileToString((File)sourceFile, (Charset)cs);
                String min = compressor.compress(source);
                FileUtils.writeStringToFile((File)destFile, (String)min, (Charset)cs);
                ++numberOfMinifiedFile;
            }
            catch (IOException e) {
                throw new MojoExecutionException("IOException when compiling JS", (Exception)e);
            }
        }
        log.info((CharSequence)(numberOfMinifiedFile + " XML file(s) were minified into target directory " + destDir.getAbsolutePath()));
    }

    public void processJs(File resourceDir, File destDir, List<String> includes, List<String> excludes, boolean useClosure, Charset cs, Log log) throws MojoExecutionException {
        if (useClosure) {
            log.info((CharSequence)"Compiling javascript using Closure");
        } else {
            log.info((CharSequence)"Compiling javascript using YUI");
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resourceDir);
        if (null == includes || includes.isEmpty()) {
            includes = Collections.singletonList("**/*.js");
        }
        scanner.setIncludes(includes.toArray(new String[includes.size()]));
        if (null != excludes && !excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        int numberOfMinifiedFile = 0;
        for (String name : scanner.getIncludedFiles()) {
            File sourceFile = new File(resourceDir, name);
            if (!sourceFile.getName().endsWith(".js")) continue;
            String baseName = FilenameUtils.removeExtension((String)name);
            File destFile = new File(destDir, baseName + "-min.js");
            if (!sourceFile.exists() || !sourceFile.canRead()) continue;
            if (destFile.exists() && destFile.lastModified() > sourceFile.lastModified()) {
                log.debug((CharSequence)("Nothing to do, " + destFile.getAbsolutePath() + " is younger than the original"));
                continue;
            }
            log.debug((CharSequence)("compressing to " + destFile.getAbsolutePath()));
            if (useClosure) {
                this.closureJsCompile(sourceFile, destFile, cs, log);
            } else {
                this.yuiJsCompile(sourceFile, destFile, log, cs);
            }
            ++numberOfMinifiedFile;
        }
        log.info((CharSequence)(numberOfMinifiedFile + " Javascript file(s) were minified into target directory " + destDir.getAbsolutePath()));
    }

    public void processCss(File resourceDir, File destDir, List<String> includes, List<String> excludes, Charset cs, Log log) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resourceDir);
        if (null == includes || includes.isEmpty()) {
            includes = Collections.singletonList("**/*.css");
        }
        scanner.setIncludes(includes.toArray(new String[includes.size()]));
        if (null != excludes && !excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        int numberOfMinifiedFile = 0;
        for (String name : scanner.getIncludedFiles()) {
            File sourceFile = new File(resourceDir, name);
            if (!sourceFile.getName().endsWith(".css")) continue;
            String baseName = FilenameUtils.removeExtension((String)name);
            File destFile = new File(destDir, baseName + "-min.css");
            if (!sourceFile.exists() || !sourceFile.canRead()) continue;
            if (destFile.exists() && destFile.lastModified() > sourceFile.lastModified()) {
                log.debug((CharSequence)("Nothing to do, " + destFile.getAbsolutePath() + " is younger than the original"));
                continue;
            }
            log.debug((CharSequence)("compressing to " + destFile.getAbsolutePath()));
            this.yuiCssCompile(sourceFile, destFile, cs);
            ++numberOfMinifiedFile;
        }
        log.info((CharSequence)(numberOfMinifiedFile + " CSS file(s) were minified into target directory " + destDir.getAbsolutePath()));
    }

    private void closureJsCompile(File sourceFile, File destFile, Charset cs, Log log) throws MojoExecutionException {
        try {
            FileUtils.forceMkdir((File)destFile.getParentFile());
            String source = FileUtils.readFileToString((File)sourceFile, (Charset)cs);
            String min = GoogleClosureJSMinifier.compile(source);
            FileUtils.writeStringToFile((File)destFile, (String)min, (Charset)cs);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException when compiling JS", (Exception)e);
        }
    }

    private void yuiJsCompile(File sourceFile, File destFile, Log log, Charset cs) throws MojoExecutionException {
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        try {
            FileUtils.forceMkdir((File)destFile.getParentFile());
            in = new InputStreamReader((InputStream)new FileInputStream(sourceFile), cs);
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), cs);
            JavaScriptCompressor yui = new JavaScriptCompressor((Reader)in, (ErrorReporter)new YUIErrorReporter(log));
            yui.compress((Writer)out, -1, true, false, false, false);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("IOException when compiling JS", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Writer)out);
    }

    private void yuiCssCompile(File sourceFile, File destFile, Charset cs) throws MojoExecutionException {
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        try {
            FileUtils.forceMkdir((File)destFile.getParentFile());
            in = new InputStreamReader((InputStream)new FileInputStream(sourceFile), cs);
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), cs);
            CssCompressor yui = new CssCompressor((Reader)in);
            yui.compress((Writer)out, -1);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("IOException when compiling JS", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Writer)out);
    }
}

