/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.UntargettedBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Qualifier;
import org.sonatype.guice.bean.reflect.DeclaredMembers;
import org.sonatype.guice.bean.reflect.DeferredProvider;
import org.sonatype.guice.bean.reflect.TypeParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DependencyAnalyzer<T>
extends DefaultBindingTargetVisitor<T, Set<Key<?>>> {
    DependencyAnalyzer() {
    }

    public Set<Key<?>> visit(UntargettedBinding<? extends T> binding) {
        return DependencyAnalyzer.analyze(binding.getKey().getTypeLiteral());
    }

    public Set<Key<?>> visit(LinkedKeyBinding<? extends T> binding) {
        return DependencyAnalyzer.analyze(binding.getLinkedKey().getTypeLiteral());
    }

    public Set<Key<?>> visit(ConstructorBinding<? extends T> binding) {
        return DependencyAnalyzer.analyze(binding.getConstructor().getDeclaringType());
    }

    public Set<Key<?>> visit(InstanceBinding<? extends T> binding) {
        return DependencyAnalyzer.analyze(TypeLiteral.get(binding.getInstance().getClass()));
    }

    public Set<Key<?>> visit(ProviderInstanceBinding<? extends T> binding) {
        Provider provider = binding.getProviderInstance();
        if (provider instanceof DeferredProvider) {
            try {
                DeferredProvider deferredProvider = (DeferredProvider)provider;
                return DependencyAnalyzer.analyze(TypeLiteral.get(deferredProvider.getImplementationClass().load()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Collections.emptySet();
    }

    public Set<Key<?>> visitOther(Binding<? extends T> binding) {
        return Collections.emptySet();
    }

    static Set<Key<?>> analyze(TypeLiteral<?> type) {
        DependencySet dependencies = new DependencySet();
        for (Member m : new DeclaredMembers(type.getRawType(), new DeclaredMembers.View[0])) {
            int i;
            Annotation[][] paramAnnotations;
            List paramTypes;
            AnnotatedElement element = (AnnotatedElement)((Object)m);
            if (!element.isAnnotationPresent(javax.inject.Inject.class) && !element.isAnnotationPresent(Inject.class)) continue;
            if (m instanceof Constructor) {
                Constructor ctor = (Constructor)m;
                paramTypes = type.getParameterTypes((Member)ctor);
                paramAnnotations = ctor.getParameterAnnotations();
                for (i = 0; i < paramAnnotations.length; ++i) {
                    dependencies.addDependency((TypeLiteral)paramTypes.get(i), paramAnnotations[i]);
                }
                continue;
            }
            if (m instanceof Method) {
                Method method = (Method)m;
                paramTypes = type.getParameterTypes((Member)method);
                paramAnnotations = method.getParameterAnnotations();
                for (i = 0; i < paramAnnotations.length; ++i) {
                    dependencies.addDependency((TypeLiteral)paramTypes.get(i), paramAnnotations[i]);
                }
                continue;
            }
            Field f = (Field)m;
            dependencies.addDependency(type.getFieldType(f), f.getAnnotations());
        }
        return dependencies;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DependencySet
    extends HashSet<Key<?>> {
        private static final long serialVersionUID = 1L;

        DependencySet() {
        }

        boolean addDependency(TypeLiteral<?> type, Annotation[] annotations) {
            TypeLiteral<?> bindingType = javax.inject.Provider.class != type.getRawType() ? type : TypeParameters.get(type, 0);
            for (Annotation ann : annotations) {
                Class<? extends Annotation> annType = ann.annotationType();
                if (!annType.isAnnotationPresent(Qualifier.class) && !annType.isAnnotationPresent(BindingAnnotation.class)) continue;
                return this.add(Key.get(bindingType, (Annotation)ann));
            }
            return this.add(Key.get(bindingType));
        }
    }
}

