/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.trap;

import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.Permission;
import java.util.LinkedList;
import java.util.List;
import org.twdata.maven.trap.App;
import org.twdata.maven.trap.MavenInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dispatcher {
    private static final String MAVEN_MAIN_CLASS = "org.codehaus.classworlds.Launcher";
    private static final String INTERCEPTORS_RESOURCE = "/org/twdata/maven/trap/interceptors";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        List<MavenInterceptor> interceptors = Dispatcher.getMavenInterceptors();
        MavenInterceptorSecurityManager securityManager = new MavenInterceptorSecurityManager(interceptors);
        System.setSecurityManager(securityManager);
        try {
            String[] updatedArgs = Dispatcher.callInterceptorsBefore(interceptors, args);
            Dispatcher.invokeMavenMainMethod(updatedArgs);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                System.exit(securityManager.exitCodeSet ? securityManager.exitCode : 0);
                throw throwable;
            }
            System.exit(securityManager.exitCodeSet ? securityManager.exitCode : 0);
        }
        System.exit(securityManager.exitCodeSet ? securityManager.exitCode : 0);
    }

    private static List<MavenInterceptor> getMavenInterceptors() throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        LinkedList<MavenInterceptor> interceptors = new LinkedList<MavenInterceptor>();
        BufferedReader reader = Dispatcher.getInterceptorsResourceBufferedReader();
        String line = reader.readLine();
        while (line != null) {
            interceptors.add((MavenInterceptor)Dispatcher.getInstanceFromName(line));
            line = reader.readLine();
        }
        return interceptors;
    }

    private static Object getInstanceFromName(String line) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Dispatcher.getClassFromName(line).newInstance();
    }

    private static Class<?> getClassFromName(String line) throws ClassNotFoundException {
        return Class.forName(line.trim());
    }

    private static BufferedReader getInterceptorsResourceBufferedReader() {
        return new BufferedReader(new InputStreamReader(Dispatcher.getInterceptorResourceAsStream()));
    }

    private static InputStream getInterceptorResourceAsStream() {
        return App.class.getClass().getResourceAsStream(INTERCEPTORS_RESOURCE);
    }

    private static String[] callInterceptorsBefore(List<MavenInterceptor> interceptors, String[] args) {
        String[] updatedArgs = args;
        for (MavenInterceptor interceptor : interceptors) {
            updatedArgs = interceptor.before(updatedArgs);
        }
        return updatedArgs;
    }

    private static void callInterceptorsAfter(List<MavenInterceptor> interceptors, int exitCode) {
        for (MavenInterceptor interceptor : interceptors) {
            interceptor.after(exitCode);
        }
    }

    private static void invokeMavenMainMethod(String[] args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        Dispatcher.getMavenMainMethod().invoke(null, new Object[]{args});
    }

    private static Method getMavenMainMethod() throws NoSuchMethodException, ClassNotFoundException {
        return Dispatcher.getMavenMainClass().getMethod("main", String[].class);
    }

    private static Class<?> getMavenMainClass() throws ClassNotFoundException {
        return Class.forName(MAVEN_MAIN_CLASS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MavenInterceptorSecurityManager
    extends SecurityManager {
        private final List<MavenInterceptor> interceptors;
        private boolean exitCodeSet = false;
        private int exitCode;

        public MavenInterceptorSecurityManager(List<MavenInterceptor> interceptors) {
            this.interceptors = interceptors;
        }

        @Override
        public void checkExit(int status) {
            this.exitCode = status;
            this.exitCodeSet = true;
            Dispatcher.callInterceptorsAfter(this.interceptors, status);
        }

        @Override
        public void checkPermission(Permission permission) {
        }

        @Override
        public void checkPermission(Permission permission, Object o) {
        }

        @Override
        public void checkCreateClassLoader() {
        }

        @Override
        public void checkAccess(Thread thread) {
        }

        @Override
        public void checkAccess(ThreadGroup threadGroup) {
        }

        @Override
        public void checkExec(String s) {
        }

        @Override
        public void checkLink(String s) {
        }

        @Override
        public void checkRead(FileDescriptor fileDescriptor) {
        }

        @Override
        public void checkRead(String s) {
        }

        @Override
        public void checkRead(String s, Object o) {
        }

        @Override
        public void checkWrite(FileDescriptor fileDescriptor) {
        }

        @Override
        public void checkWrite(String s) {
        }

        @Override
        public void checkDelete(String s) {
        }

        @Override
        public void checkConnect(String s, int i) {
        }

        @Override
        public void checkConnect(String s, int i, Object o) {
        }

        @Override
        public void checkListen(int i) {
        }

        @Override
        public void checkAccept(String s, int i) {
        }

        @Override
        public void checkMulticast(InetAddress inetAddress) {
        }

        @Override
        public void checkPropertiesAccess() {
        }

        @Override
        public void checkPropertyAccess(String s) {
        }

        public boolean checkTopLevelWindow(Object o) {
            return true;
        }

        @Override
        public void checkPrintJobAccess() {
        }

        public void checkSystemClipboardAccess() {
        }

        public void checkAwtEventQueueAccess() {
        }

        @Override
        public void checkPackageAccess(String s) {
        }

        @Override
        public void checkPackageDefinition(String s) {
        }

        @Override
        public void checkSetFactory() {
        }

        public void checkMemberAccess(Class<?> aClass, int i) {
        }

        @Override
        public void checkSecurityAccess(String s) {
        }
    }
}

