/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.trap.colorizer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import org.twdata.maven.trap.EnvMavenInterceptor;
import org.twdata.maven.trap.colorizer.OutputLexer;

public class MavenColorizerInterceptor
extends EnvMavenInterceptor {
    public String[] onBefore(String[] args) {
        System.out.println("Colorizing console...");
        System.setOut(new PrintStream(new LexingOutputStream()));
        return args;
    }

    public void onAfter(int exitCode) {
    }

    protected String getEnvironmentVariableName() {
        return "MAVEN_COLOR";
    }

    private static class LexingOutputStream
    extends OutputStream {
        private final OutputLexer lexer = new OutputLexer(new StringReader(""));
        private int lastState = this.lexer.yystate();

        public void write(int i) throws IOException {
            this.lexer.yyreset(new InputStreamReader(new ByteArrayInputStream(new byte[i])));
            this.lexer.yybegin(this.lastState);
            this.lexer.yylex();
            this.lastState = this.lexer.yystate();
        }

        public void write(byte[] bytes, int pos, int len) throws IOException {
            this.lexer.yyreset(new InputStreamReader(new ByteArrayInputStream(bytes, pos, len)));
            this.lexer.yybegin(this.lastState);
            this.lexer.yylex();
            this.lastState = this.lexer.yystate();
        }
    }
}

