/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.trap.colorizer;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.twdata.maven.trap.colorizer.Color;

public class VT100Writer {
    static final char CHAR_END = 'm';
    static final String ESC = "\u001b[";
    static final Map<Color, String> foregroundColorCodes = new HashMap<Color, String>();
    static final Map<Color, String> backgroundColorCodes = new HashMap<Color, String>();
    private final PrintStream out;

    public VT100Writer(PrintStream out) {
        this.out = out;
    }

    public VT100Writer fg(Color color, CharacterModifier ... mods) {
        this.color(foregroundColorCodes.get((Object)color), mods);
        return this;
    }

    public VT100Writer bg(Color color, CharacterModifier ... mods) {
        this.color(backgroundColorCodes.get((Object)color), mods);
        return this;
    }

    public VT100Writer mod(CharacterModifier mod) {
        this.out.print(ESC);
        this.out.print(mod.getMod());
        this.out.print('m');
        return this;
    }

    public VT100Writer clear() {
        this.out.print(ESC);
        this.out.print('m');
        return this;
    }

    VT100Writer color(String colorCode, CharacterModifier ... mods) {
        this.out.print(ESC);
        for (int x = 0; x < mods.length; ++x) {
            this.out.print(mods[x].getMod());
            if (mods.length == x - 1 && colorCode == null) continue;
            this.out.print(';');
        }
        if (colorCode != null) {
            this.out.print(colorCode);
        }
        this.out.print('m');
        return this;
    }

    static {
        foregroundColorCodes.put(Color.BLACK, "30");
        foregroundColorCodes.put(Color.RED, "31");
        foregroundColorCodes.put(Color.GREEN, "32");
        foregroundColorCodes.put(Color.YELLOW, "33");
        foregroundColorCodes.put(Color.BLUE, "34");
        foregroundColorCodes.put(Color.MAGENTA, "35");
        foregroundColorCodes.put(Color.CYAN, "36");
        foregroundColorCodes.put(Color.WHITE, "37");
        backgroundColorCodes.put(Color.BLACK, "40");
        backgroundColorCodes.put(Color.RED, "41");
        backgroundColorCodes.put(Color.GREEN, "42");
        backgroundColorCodes.put(Color.YELLOW, "43");
        backgroundColorCodes.put(Color.BLUE, "44");
        backgroundColorCodes.put(Color.MAGENTA, "45");
        backgroundColorCodes.put(Color.CYAN, "46");
        backgroundColorCodes.put(Color.WHITE, "47");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharacterModifier {
        CLEAR('0'),
        BOLD('1'),
        UNDERSCORE('4'),
        BLINK('5'),
        REVERSE('7');

        private char mod;

        private CharacterModifier(char mod) {
            this.mod = mod;
        }

        public char getMod() {
            return this.mod;
        }
    }
}

