/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.yamlpom;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.twdata.maven.yamlpom.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConverter<T extends AbstractConverter> {
    private File toFile;
    private File fromFile;
    protected String tab;
    protected Log log;

    public T targetFile(File toFile) {
        this.toFile = toFile;
        return (T)this;
    }

    public T fromFile(File fromFile) {
        this.fromFile = fromFile;
        return (T)this;
    }

    public T indentSpaces(int spaces) {
        String tab = "";
        for (int x = 0; x < spaces; ++x) {
            tab = tab + " ";
        }
        this.tab = tab;
        return (T)this;
    }

    public T logWith(Log log) {
        this.log = log;
        return (T)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert() throws IOException {
        FileReader reader;
        block3: {
            reader = null;
            try {
                reader = new FileReader(this.fromFile);
                String text = this.buildTarget(reader);
                if (this.isValidTargetContents(text)) {
                    FileUtils.writeStringToFile(this.toFile, text);
                    break block3;
                }
                this.log.error("Cannot generate a valid document for " + this.toFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
    }

    protected abstract String buildTarget(Reader var1) throws IOException;

    protected abstract boolean isValidTargetContents(String var1);
}

