/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.yamlpom;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.twdata.maven.yamlpom.Converter;
import org.twdata.maven.yamlpom.ConverterOptions;
import org.twdata.maven.yamlpom.InvalidFormatException;
import org.twdata.maven.yamlpom.Log;
import org.twdata.maven.yamlpom.XmlToYamlConverter;
import org.twdata.maven.yamlpom.YamlToXmlConverter;

public class ConverterBuilder {
    private File toFile;
    private File fromFile;
    private Reader fromReader;
    private Writer toWriter;
    private final Converter converter;
    private final ConverterOptions options;

    private ConverterBuilder(Converter converter) {
        this.converter = converter;
        this.options = new ConverterOptions();
    }

    public static ConverterBuilder convertXmlToYaml() {
        return new ConverterBuilder(new XmlToYamlConverter());
    }

    public static ConverterBuilder convertYamlToXml() {
        return new ConverterBuilder(new YamlToXmlConverter());
    }

    public ConverterBuilder toFile(File toFile) {
        this.toFile = toFile;
        return this;
    }

    public ConverterBuilder toWriter(Writer writer) {
        this.toWriter = writer;
        return this;
    }

    public ConverterBuilder fromFile(File fromFile) {
        this.fromFile = fromFile;
        return this;
    }

    public ConverterBuilder fromReader(Reader fromReader) {
        this.fromReader = fromReader;
        return this;
    }

    public ConverterBuilder indentSpaces(int spaces) {
        String tab = "";
        for (int x = 0; x < spaces; ++x) {
            tab = tab + " ";
        }
        this.options.indent(tab);
        return this;
    }

    public ConverterBuilder logWith(Log log) {
        this.options.log(log);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert() throws IOException, InvalidFormatException {
        block6: {
            Reader reader = this.fromReader;
            Writer writer = this.toWriter;
            try {
                String text;
                if (reader == null) {
                    reader = new FileReader(this.fromFile);
                }
                if (writer == null) {
                    writer = new FileWriter(this.toFile);
                }
                if ((text = this.converter.convert(reader, this.options)) != null && text.trim().length() > 0) {
                    IOUtils.write(text, writer);
                    break block6;
                }
                throw new InvalidFormatException("No converted text", null);
            }
            finally {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(writer);
            }
        }
    }
}

