/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.yamlpom;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.twdata.maven.yamlpom.ConverterBuilder;
import org.twdata.maven.yamlpom.InvalidFormatException;
import org.twdata.maven.yamlpom.MavenLog;
import org.twdata.maven.yamlpom.SyncManager;

public class SyncPomMojo
extends AbstractMojo {
    private String yamlPomName = "pom.yml";
    private String syncFileName = ".pom.yml";
    private int yamlIndent = 2;
    private int xmlIndent = 4;
    private boolean failIfXmlSync = true;
    private boolean failIfCannotSync = true;
    private String target = "auto";
    private File basedir;

    public void execute() throws MojoExecutionException {
        File xmlFile = new File(this.basedir, "pom.xml");
        File yamlFile = new File(this.basedir, this.yamlPomName);
        File syncFile = new File(this.basedir, this.syncFileName);
        SyncManager syncManager = new SyncManager(xmlFile, yamlFile, syncFile);
        try {
            switch (this.determineTarget(syncManager)) {
                case YAML: {
                    this.getLog().info((CharSequence)("Converting " + xmlFile.getName() + " into " + yamlFile.getName()));
                    this.sync(xmlFile, yamlFile, syncFile, false);
                    syncManager.save();
                    break;
                }
                case XML: {
                    this.getLog().info((CharSequence)("Converting " + yamlFile.getName() + " into " + xmlFile.getName()));
                    this.sync(xmlFile, yamlFile, syncFile, true);
                    syncManager.save();
                    if (!this.failIfXmlSync) break;
                    throw new MojoExecutionException("pom.xml modified.  You must retry your Maven command.");
                }
                case SYNC_FILE_ONLY: {
                    this.getLog().info((CharSequence)"Files in sync, creating a sync file");
                    syncManager.save();
                    break;
                }
                case NONE: {
                    this.getLog().info((CharSequence)"No sync required");
                    break;
                }
                case UNKNOWN: {
                    if (this.failIfCannotSync) {
                        throw new MojoExecutionException("Unable to automatically sync");
                    }
                    this.getLog().error((CharSequence)"Unable to automatically sync due to changes to both XML and YAML since last sync.");
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error syncing YAML pom", (Exception)e);
        }
        catch (InvalidFormatException e) {
            throw new MojoExecutionException("Unable to create or parse a valid format: \n" + e.getText(), (Exception)e);
        }
    }

    private SyncManager.FormatToTarget determineTarget(SyncManager syncManager) {
        if (this.target.equalsIgnoreCase("yaml") || this.target.equalsIgnoreCase("yml")) {
            return SyncManager.FormatToTarget.YAML;
        }
        if (this.target.equalsIgnoreCase("xml")) {
            return SyncManager.FormatToTarget.XML;
        }
        return syncManager.determineFormatToTarget();
    }

    private void sync(File xmlFile, File yamlFile, File syncFile, boolean xmlFirst) throws IOException, InvalidFormatException {
        if (xmlFirst) {
            ConverterBuilder.convertYamlToXml().indentSpaces(this.xmlIndent).fromFile(yamlFile).toFile(xmlFile).logWith(new MavenLog(this.getLog())).convert();
            ConverterBuilder.convertXmlToYaml().indentSpaces(this.yamlIndent).fromFile(xmlFile).toFile(yamlFile).logWith(new MavenLog(this.getLog())).convert();
        } else {
            ConverterBuilder.convertXmlToYaml().indentSpaces(this.yamlIndent).fromFile(xmlFile).toFile(yamlFile).logWith(new MavenLog(this.getLog())).convert();
            ConverterBuilder.convertYamlToXml().indentSpaces(this.xmlIndent).fromFile(yamlFile).toFile(xmlFile).logWith(new MavenLog(this.getLog())).convert();
        }
    }
}

