/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.serializer.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRepresenter {
    protected final Map<Class, Represent> representers = new HashMap<Class, Represent>();
    protected Represent nullRepresenter;
    protected final Map<Class, Represent> multiRepresenters = new HashMap<Class, Represent>();
    private Character defaultStyle;
    protected Boolean defaultFlowStyle;
    protected final Map<Integer, Node> representedObjects = new HashMap<Integer, Node>();
    private final Set<Object> objectKeeper = new HashSet<Object>();
    protected Integer aliasKey;
    protected String rootTag = null;

    public BaseRepresenter(Character default_style, Boolean default_flow_style) {
        this.defaultStyle = default_style;
        this.defaultFlowStyle = default_flow_style;
    }

    public void represent(Serializer serializer, Object data) throws IOException {
        Node node = this.representData(data);
        serializer.serialize(node);
        this.representedObjects.clear();
        this.objectKeeper.clear();
    }

    protected Node representData(Object data) {
        Node node;
        this.aliasKey = System.identityHashCode(data);
        if (!this.ignoreAliases(data) && this.representedObjects.containsKey(this.aliasKey)) {
            Node node2 = this.representedObjects.get(this.aliasKey);
            return node2;
        }
        if (data == null) {
            Node node3 = this.nullRepresenter.representData(data);
            return node3;
        }
        Class<?> clazz = data.getClass();
        if (this.representers.containsKey(clazz)) {
            Represent representer = this.representers.get(clazz);
            node = representer.representData(data);
        } else {
            Represent representer;
            for (Class repr : this.multiRepresenters.keySet()) {
                if (!repr.isInstance(data)) continue;
                Represent representer2 = this.multiRepresenters.get(repr);
                Node node4 = representer2.representData(data);
                return node4;
            }
            if (clazz.isArray()) {
                throw new YAMLException("Arrays of primitives are not fully supported.");
            }
            if (this.multiRepresenters.containsKey(null)) {
                representer = this.multiRepresenters.get(null);
                node = representer.representData(data);
            } else {
                representer = this.representers.get(null);
                node = representer.representData(data);
            }
        }
        return node;
    }

    protected Node representScalar(String tag, String value, Character style) {
        if (style == null) {
            style = this.defaultStyle;
        }
        ScalarNode node = new ScalarNode(tag, value, null, null, style);
        this.representedObjects.put(this.aliasKey, node);
        return node;
    }

    protected Node representScalar(String tag, String value) {
        return this.representScalar(tag, value, null);
    }

    protected Node representSequence(String tag, List<? extends Object> sequence, Boolean flowStyle) {
        LinkedList<Node> value = new LinkedList<Node>();
        SequenceNode node = new SequenceNode(tag, value, flowStyle);
        this.representedObjects.put(this.aliasKey, node);
        boolean bestStyle = true;
        for (Object object : sequence) {
            Node nodeItem = this.representData(object);
            if (!(nodeItem instanceof ScalarNode) || ((ScalarNode)nodeItem).getStyle() != null) {
                bestStyle = false;
            }
            value.add(nodeItem);
        }
        if (flowStyle == null) {
            if (this.defaultFlowStyle != null) {
                node.setFlowStyle(this.defaultFlowStyle);
            } else {
                node.setFlowStyle(bestStyle);
            }
        }
        return node;
    }

    protected Node representMapping(String tag, Map<? extends Object, Object> mapping, Boolean flowStyle) {
        LinkedList<Node[]> value = new LinkedList<Node[]>();
        MappingNode node = new MappingNode(tag, value, flowStyle);
        this.representedObjects.put(this.aliasKey, node);
        boolean bestStyle = true;
        for (Object object : mapping.keySet()) {
            Object itemValue = mapping.get(object);
            Node nodeKey = this.representData(object);
            Node nodeValue = this.representData(itemValue);
            if (!(nodeKey instanceof ScalarNode) || ((ScalarNode)nodeKey).getStyle() != null) {
                bestStyle = false;
            }
            if (!(nodeValue instanceof ScalarNode) || ((ScalarNode)nodeValue).getStyle() != null) {
                bestStyle = false;
            }
            value.add(new Node[]{nodeKey, nodeValue});
        }
        if (flowStyle == null) {
            if (this.defaultFlowStyle != null) {
                node.setFlowStyle(this.defaultFlowStyle);
            } else {
                node.setFlowStyle(bestStyle);
            }
        }
        return node;
    }

    protected abstract boolean ignoreAliases(Object var1);
}

