/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.SafeRepresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Representer
extends SafeRepresenter {
    private Map<Class<? extends Object>, String> classTags = new HashMap<Class<? extends Object>, String>();
    private Map<Class<? extends Object>, TypeDescription> classDefinitions = new HashMap<Class<? extends Object>, TypeDescription>();

    public Representer(Character default_style, Boolean default_flow_style) {
        super(default_style, default_flow_style);
        this.representers.put(null, new RepresentJavaBean());
    }

    public Representer() {
        this(null, null);
    }

    public TypeDescription addTypeDescription(TypeDescription definition) {
        if (definition == null) {
            throw new NullPointerException("ClassDescription is required.");
        }
        String tag = definition.getTag();
        this.classTags.put(definition.getType(), tag);
        return this.classDefinitions.put(definition.getType(), definition);
    }

    private Node representMapping(Set<Property> properties, Object javaBean) {
        LinkedList<Node[]> value = new LinkedList<Node[]>();
        String customTag = this.classTags.get(javaBean.getClass());
        String tag = customTag == null ? (this.rootTag == null ? "tag:yaml.org,2002:" + javaBean.getClass().getName() : "tag:yaml.org,2002:map") : customTag;
        if (this.rootTag == null) {
            this.rootTag = tag;
        }
        MappingNode node = new MappingNode(tag, value, null);
        this.representedObjects.put(this.aliasKey, node);
        boolean bestStyle = true;
        for (Property property : properties) {
            Node nodeKey = this.representData(property.getName());
            Object memberValue = property.get(javaBean);
            Node nodeValue = this.representData(memberValue);
            if (nodeValue instanceof MappingNode) {
                if (!Map.class.isAssignableFrom(memberValue.getClass()) && property.getType() != memberValue.getClass()) {
                    String memberTag = "tag:yaml.org,2002:" + memberValue.getClass().getName();
                    nodeValue.setTag(memberTag);
                }
            } else if (memberValue != null && Enum.class.isAssignableFrom(memberValue.getClass())) {
                nodeValue.setTag("tag:yaml.org,2002:str");
            }
            if (!(nodeKey instanceof ScalarNode) || ((ScalarNode)nodeKey).getStyle() != null) {
                bestStyle = false;
            }
            if (!(nodeValue instanceof ScalarNode) || ((ScalarNode)nodeValue).getStyle() != null) {
                bestStyle = false;
            }
            value.add(new Node[]{nodeKey, nodeValue});
        }
        if (this.defaultFlowStyle != null) {
            node.setFlowStyle(this.defaultFlowStyle);
        } else {
            node.setFlowStyle(bestStyle);
        }
        return node;
    }

    private Set<Property> getProperties(Class<? extends Object> type) throws IntrospectionException {
        TreeSet<Property> properties = new TreeSet<Property>();
        for (PropertyDescriptor property : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
            if (property.getReadMethod() == null || property.getReadMethod().getName().equals("getClass")) continue;
            properties.add(new MethodProperty(property));
        }
        for (Field field : type.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            properties.add(new FieldProperty(field));
        }
        return properties;
    }

    private class RepresentJavaBean
    implements Represent {
        private RepresentJavaBean() {
        }

        public Node representData(Object data) {
            Set properties;
            try {
                properties = Representer.this.getProperties(data.getClass());
            }
            catch (IntrospectionException e) {
                throw new YAMLException(e);
            }
            Node node = Representer.this.representMapping(properties, data);
            return node;
        }
    }
}

