/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.fugue.Option;
import com.google.common.base.Preconditions;
import java.util.Iterator;

public final class VersionId {
    private final Option<String> version;
    private final Option<String> propertyName;

    public static VersionId version(String version) {
        return new VersionId((Option<String>)Option.some((Object)version), (Option<String>)Option.none(String.class));
    }

    public static VersionId versionProperty(String propertyName, String defaultVersion) {
        return new VersionId((Option<String>)Option.some((Object)defaultVersion), (Option<String>)Option.some((Object)propertyName));
    }

    public static VersionId noVersion() {
        return new VersionId((Option<String>)Option.none(String.class), (Option<String>)Option.none(String.class));
    }

    private VersionId(Option<String> version, Option<String> propertyName) {
        this.version = (Option)Preconditions.checkNotNull(version, (Object)"version");
        this.propertyName = (Option)Preconditions.checkNotNull(propertyName, (Object)"propertyName");
    }

    public Option<String> getVersion() {
        return this.version;
    }

    public Option<String> getPropertyName() {
        return this.propertyName;
    }

    public boolean isDefined() {
        return this.version.isDefined() || this.propertyName.isDefined();
    }

    public Option<String> getVersionOrPropertyPlaceholder() {
        Iterator i$ = this.propertyName.iterator();
        if (i$.hasNext()) {
            String p = (String)i$.next();
            return Option.some((Object)this.placeholder(p));
        }
        return this.version;
    }

    public String toString() {
        Iterator i$ = this.propertyName.iterator();
        if (i$.hasNext()) {
            String p = (String)i$.next();
            Iterator i$2 = this.version.iterator();
            if (i$2.hasNext()) {
                String v = (String)i$2.next();
                return this.placeholder(p) + " (" + v + ")";
            }
            return this.placeholder(p);
        }
        i$ = this.version.iterator();
        if (i$.hasNext()) {
            String v = (String)i$.next();
            return v;
        }
        return "?";
    }

    private String placeholder(String p) {
        return "${" + p + "}";
    }

    public boolean equals(Object other) {
        if (other instanceof VersionId) {
            VersionId v = (VersionId)other;
            return this.version.equals(v.version) && this.propertyName.equals(v.propertyName);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

