/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.annotations.asm;

import com.atlassian.plugins.codegen.annotations.asm.AbstractAnnotationParser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ProductContextProviderLocator
extends AbstractAnnotationParser {
    protected static final Map<String, String> productContextPackages = new HashMap<String, String>();
    private String productId;
    private Map<String, String> contextRegistry;

    public ProductContextProviderLocator(String productId, Map<String, String> contextRegistry) {
        this.productId = productId;
        this.contextRegistry = contextRegistry;
    }

    public void parse() throws Exception {
        String basePackage = productContextPackages.get(this.productId);
        if (StringUtils.isNotBlank((String)basePackage)) {
            this.parse(basePackage, new ContextProviderClassVisitor());
        }
    }

    public void parse(String basePackage) throws Exception {
        this.parse(basePackage, new ContextProviderClassVisitor());
    }

    static {
        productContextPackages.put("jira", "com.atlassian.jira.plugin.webfragment.contextproviders");
        productContextPackages.put("confluence", "com.atlassian.jira.plugin.webfragment.contextproviders");
        productContextPackages.put("bamboo", "com.atlassian.jira.plugin.webfragment.contextproviders");
        productContextPackages.put("crowd", "com.atlassian.jira.plugin.webfragment.contextproviders");
        productContextPackages.put("fecru", "com.atlassian.jira.plugin.webfragment.contextproviders");
        productContextPackages.put("refapp", "com.atlassian.jira.plugin.webfragment.contextproviders");
    }

    public class ContextProviderClassVisitor
    extends ClassVisitor {
        private String visitedClassname;
        private boolean isContextProvider;

        public ContextProviderClassVisitor() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            boolean isAbstract;
            this.visitedClassname = ProductContextProviderLocator.normalize((String)name);
            String iface = "com/atlassian/plugin/web/ContextProvider";
            this.isContextProvider = false;
            boolean bl = isAbstract = (access & 0x400) > 0;
            if (!isAbstract) {
                this.isContextProvider = ArrayUtils.contains((Object[])interfaces, (Object)iface);
                if (!this.isContextProvider) {
                    this.isContextProvider = this.superHasInterface(superName, iface);
                }
            }
            if (this.isContextProvider) {
                String simpleName = StringUtils.substringAfterLast((String)this.visitedClassname, (String)".");
                ProductContextProviderLocator.this.contextRegistry.put(simpleName, this.visitedClassname);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean superHasInterface(String superName, String interfaceName) {
            InputStream is;
            boolean hasInterface;
            block5: {
                hasInterface = false;
                if (ProductContextProviderLocator.normalize((String)superName).equals("java.lang.Object")) {
                    return false;
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String path = superName.replace('.', '/');
                is = null;
                try {
                    ClassReader classReader;
                    is = classLoader.getResourceAsStream(path + ".class");
                    if (null == is || (hasInterface = ArrayUtils.contains((Object[])(classReader = new ClassReader(is)).getInterfaces(), (Object)interfaceName))) break block5;
                    hasInterface = this.superHasInterface(classReader.getSuperName(), interfaceName);
                }
                catch (Exception e) {
                    IOUtils.closeQuietly(is);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return hasInterface;
        }
    }
}

