/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DomHelper {
    private static final String XMLNS_PREFIX = "xmlns";
    private static final String XMLNS_PREFIX_COLON = "xmlns:";
    private static final int XMLNS_PREFIX_COLON_LENGTH = "xmlns:".length();

    private DomHelper() {
    }

    public static QName getElementQName(Element element) {
        if (element.getPrefix() != null) {
            return new QName(element.getNamespaceURI(), element.getLocalName(), element.getPrefix());
        }
        return new QName(element.getNamespaceURI(), element.getLocalName());
    }

    public static String getElementName(Element element) {
        if (element.getPrefix() != null && element.getPrefix().length() > 0) {
            return element.getPrefix() + ':' + element.getLocalName();
        }
        return element.getLocalName();
    }

    public static String getElementText(Element element) {
        StringBuilder builder = new StringBuilder(10);
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof Text)) continue;
            builder.append(((CharacterData)n).getData());
        }
        return builder.toString();
    }

    public static Map<String, String> getAttributes(Element element) {
        HashMap<String, String> ret = new HashMap<String, String>();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            String attrName = attr.getName();
            if (attrName.startsWith(XMLNS_PREFIX_COLON) || attrName.equals(XMLNS_PREFIX)) continue;
            ret.put(attrName, attr.getValue());
        }
        return ret;
    }

    public static Map<String, String> getDeclaredPrefixes(Element element, Map<String, String> parentPrefixes) {
        TreeMap<String, String> ret = new TreeMap<String, String>(parentPrefixes);
        if (element.getNamespaceURI() != null) {
            ret.put("", element.getNamespaceURI());
        }
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            String attrName = attr.getName();
            if (!attrName.startsWith(XMLNS_PREFIX_COLON)) continue;
            ret.put(attrName.substring(XMLNS_PREFIX_COLON_LENGTH), attr.getValue());
        }
        return ret;
    }

    public static List<Element> getChildElements(Node node) {
        ArrayList<Element> ret = new ArrayList<Element>(5);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            ret.add((Element)child);
        }
        return ret;
    }
}

