/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.Opaqueable;
import oracle.sql.DatumWithConnection;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.xdb.XMLType;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLSAXSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

final class OracleSQLXML
extends DatumWithConnection
implements SQLXML,
Opaqueable {
    private XMLType xdb;
    private boolean isReadable = false;
    private boolean isWriteable = false;
    private DOMResult domResult = null;
    private XMLSAXSerializer serializer = null;
    private ByteArrayOutputStream oStream = null;
    static final int INITIAL_BUFFER_SIZE = 16384;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_12:18:34_PDT_2010";
    public static final boolean TRACE = false;

    OracleSQLXML(Connection connection) throws SQLException {
        this.setPhysicalConnectionOf(connection);
        this.isReadable = false;
        this.isWriteable = true;
    }

    OracleSQLXML(Connection connection, OPAQUE oPAQUE) throws SQLException {
        this.setPhysicalConnectionOf(connection);
        this.isReadable = true;
        this.isWriteable = false;
        this.xdb = oPAQUE instanceof XMLType ? (XMLType)oPAQUE : new XMLType(oPAQUE.getDescriptor(), (Connection)this.getInternalConnection(), (Object)oPAQUE.getBytesValue());
    }

    OracleSQLXML(OpaqueDescriptor opaqueDescriptor, Connection connection, byte[] byArray) throws SQLException {
        this(connection, new OPAQUE(opaqueDescriptor, byArray, connection));
    }

    OracleSQLXML(Connection connection, InputStream inputStream) throws SQLException {
        this.setPhysicalConnectionOf(connection);
        this.isReadable = true;
        this.isWriteable = false;
        this.xdb = new XMLType((Connection)this.getInternalConnection(), inputStream);
    }

    OracleSQLXML(Connection connection, XMLType xMLType) throws SQLException {
        this.setPhysicalConnectionOf(connection);
        this.isReadable = true;
        this.isWriteable = false;
        this.xdb = xMLType;
    }

    @Override
    public OPAQUE toOpaque() throws SQLException {
        return this.getXMLTypeInternal();
    }

    XMLType getXMLTypeInternal() throws SQLException {
        Object object;
        if (this.isWriteable) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 260);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.serializer != null) {
            try {
                this.serializer.flush();
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                this.serializer = null;
            }
        }
        if (this.oStream != null) {
            try {
                this.oStream.close();
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.xdb = XMLType.createXML((Connection)this.getInternalConnection(), (InputStream)new ByteArrayInputStream(this.oStream.toByteArray()));
            this.oStream = null;
        } else if (this.domResult != null) {
            object = this.domResult.getNode();
            Document document = null;
            if (object instanceof Document) {
                document = (Document)object;
            } else {
                document = new XMLDocument();
                object = document.importNode((Node)object, true);
                document.insertBefore((Node)object, null);
            }
            this.xdb = XMLType.createXML((Connection)this.getInternalConnection(), (Document)document);
            this.domResult = null;
        }
        if (this.xdb == null) {
            object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 260);
            ((Throwable)object).fillInStackTrace();
            throw object;
        }
        return this.xdb;
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return null;
    }

    @Override
    public void free() throws SQLException {
        this.isReadable = false;
        this.isWriteable = false;
        this.oStream = null;
        this.domResult = null;
        if (this.xdb != null) {
            this.xdb.close();
        }
        this.xdb = null;
    }

    InputStream getInputStream() throws SQLException {
        return new ByteArrayInputStream(this.xdb.getStringVal().getBytes());
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (!this.isReadable) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 261);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.isReadable = false;
        return this.getInputStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (!this.isReadable) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 261);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.isReadable = false;
        return new StringReader(this.xdb.getStringVal());
    }

    @Override
    public <T extends Source> T getSource(Class<T> clazz) throws SQLException {
        if (!this.isReadable) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 261);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.isReadable = false;
        if (clazz == DOMSource.class) {
            Document document = this.xdb.getDocument();
            return (T)new DOMSource(document);
        }
        if (clazz == SAXSource.class) {
            InputSource inputSource = new InputSource(this.getInputStream());
            return (T)new SAXSource(inputSource);
        }
        if (clazz == StAXSource.class) {
            try {
                XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(this.getInputStream());
                return (T)new StAXSource(xMLStreamReader);
            }
            catch (XMLStreamException xMLStreamException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xMLStreamException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (clazz == StreamSource.class) {
            return (T)new StreamSource(this.getInputStream());
        }
        this.isReadable = true;
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 264);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public String getString() throws SQLException {
        if (!this.isReadable) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 261);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.isReadable = false;
        return this.xdb.getStringVal();
    }

    protected OutputStream getOutputStream() throws SQLException {
        if (this.oStream != null) {
            throw new SQLException("Internal Error");
        }
        this.oStream = new ByteArrayOutputStream(16384);
        return this.oStream;
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        if (!this.isWriteable) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 262);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.isWriteable = false;
        return this.getOutputStream();
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        if (!this.isWriteable) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 262);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.isWriteable = false;
        return new OutputStreamWriter(this.getOutputStream());
    }

    @Override
    public <T extends Result> T setResult(Class<T> clazz) throws SQLException {
        if (!this.isWriteable) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 262);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.isWriteable = false;
        if (clazz == DOMResult.class) {
            this.domResult = new DOMResult();
            return (T)this.domResult;
        }
        if (clazz == SAXResult.class) {
            this.serializer = new XMLSAXSerializer(this.getOutputStream());
            return (T)new SAXResult((ContentHandler)this.serializer);
        }
        if (clazz == StAXResult.class) {
            try {
                XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
                return (T)new StAXResult(xMLOutputFactory.createXMLStreamWriter(this.getOutputStream()));
            }
            catch (XMLStreamException xMLStreamException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xMLStreamException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (clazz == StreamResult.class) {
            return (T)new StreamResult(this.getOutputStream());
        }
        this.isWriteable = true;
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 263);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void setString(String string) throws SQLException {
        if (!this.isWriteable) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 262);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.isWriteable = false;
        this.xdb = new XMLType((Connection)this.getInternalConnection(), string);
    }
}

