/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.oscache.base.algorithm;

import com.opensymphony.module.oscache.base.persistence.CachePersistenceException;
import com.opensymphony.module.oscache.base.persistence.PersistenceListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class AbstractConcurrentReadCache
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    protected final transient Object barrierLock = new Object();
    protected transient Object lastWrite;
    public static int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry[] table;
    protected transient int count;
    protected int threshold;
    protected float loadFactor;
    protected static final String NULL = "_nul!~";
    protected PersistenceListener persistenceListener = null;
    protected boolean memoryCaching = true;
    protected boolean unlimitedDiskCache = false;
    protected final int DEFAULT_MAX_ENTRIES = 100;
    protected int maxEntries = 100;
    protected final int UNLIMITED = 0x7FFFFFFE;
    protected transient Set keySet = null;
    protected transient Set entrySet = null;
    protected transient Collection values = null;

    protected final void recordModification(Object object) {
        Object object2 = this.barrierLock;
        synchronized (object2) {
            this.lastWrite = object;
        }
    }

    protected final Entry[] getTableForReading() {
        Object object = this.barrierLock;
        synchronized (object) {
            Entry[] entryArray = this.table;
            return entryArray;
        }
    }

    protected Object persistRetrieve(Object object) {
        Object object2 = null;
        if (this.persistenceListener != null) {
            try {
                object2 = this.persistenceListener.retrieve((String)object);
            }
            catch (CachePersistenceException cachePersistenceException) {
                // empty catch block
            }
        }
        return object2;
    }

    protected void persistStore(Object object, Object object2) {
        if (this.persistenceListener != null) {
            try {
                this.persistenceListener.store((String)object, object2);
            }
            catch (CachePersistenceException cachePersistenceException) {
                System.err.println("[oscache] Exception persisting " + object + " : " + cachePersistenceException);
            }
        }
    }

    protected void persistRemove(Object object) {
        if (this.persistenceListener != null) {
            try {
                this.persistenceListener.remove((String)object);
            }
            catch (CachePersistenceException cachePersistenceException) {
                System.err.println("[oscache] Exception removing from persistence: " + cachePersistenceException);
            }
        }
    }

    public void setMemoryCaching(boolean bl) {
        this.memoryCaching = bl;
    }

    public boolean isMemoryCaching() {
        return this.memoryCaching;
    }

    public void setUnlimitedDiskCache(boolean bl) {
        this.unlimitedDiskCache = bl;
    }

    public boolean isUnlimitedDiskCache() {
        return this.unlimitedDiskCache;
    }

    public void setPersistenceListener(PersistenceListener persistenceListener) {
        this.persistenceListener = persistenceListener;
    }

    public PersistenceListener getPersistenceListener() {
        return this.persistenceListener;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public void setMaxEntries(int n) {
        if (n > 0) {
            this.maxEntries = n;
            while (this.size() > this.maxEntries) {
                this.remove(this.removeItem(), false);
            }
        } else {
            throw new IllegalArgumentException("Cache maximum number of entries must  be at least 1");
        }
    }

    protected abstract void getItem(Object var1);

    protected abstract void putItem(Object var1);

    protected abstract Object removeItem();

    protected abstract void removeItem(Object var1);

    private int p2capacity(int n) {
        int n2;
        int n3 = n;
        if (n3 > 0x40000000 || n3 < 0) {
            n2 = 0x40000000;
        } else {
            n2 = 4;
            while (n2 < n3) {
                n2 <<= 1;
            }
        }
        return n2;
    }

    private static int hash(Object object) {
        int n = object.hashCode();
        return (n << 7) - n + (n >>> 9) + (n >>> 17);
    }

    public AbstractConcurrentReadCache(int n, float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        this.loadFactor = f;
        int n2 = this.p2capacity(n);
        this.table = new Entry[n2];
        this.threshold = (int)((float)n2 * f);
    }

    public AbstractConcurrentReadCache(int n) {
        this(n, 0.75f);
    }

    public AbstractConcurrentReadCache() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    public AbstractConcurrentReadCache(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public Object get(Object object) {
        Entry entry;
        int n = AbstractConcurrentReadCache.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            Object object2;
            if (entry2 == null) {
                entryArray = this.getTableForReading();
                if (entry == entryArray[n2]) {
                    object2 = this.persistRetrieve(object);
                    if (object2 != null) {
                        this.put(object, object2, false);
                    }
                    return object2;
                }
                n2 = n & entryArray.length - 1;
                entry2 = entry = entryArray[n2];
                continue;
            }
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                object2 = entry2.value;
                if (object2 != null) {
                    if (NULL.equals(object2)) {
                        object2 = this.persistRetrieve(entry2.key);
                        if (object2 != null) {
                            this.getItem(object);
                            return object2;
                        }
                    } else {
                        this.getItem(object);
                        return object2;
                    }
                }
                AbstractConcurrentReadCache abstractConcurrentReadCache = this;
                synchronized (abstractConcurrentReadCache) {
                    entryArray = this.table;
                }
                n2 = n & entryArray.length - 1;
                entry2 = entry = entryArray[n2];
                continue;
            }
            entry2 = entry2.next;
        }
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public Object put(Object object, Object object2) {
        return this.put(object, object2, true);
    }

    private Object put(Object object, Object object2, boolean bl) {
        Entry entry;
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n = AbstractConcurrentReadCache.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            if (entry2 == null) {
                AbstractConcurrentReadCache abstractConcurrentReadCache = this;
                synchronized (abstractConcurrentReadCache) {
                    entryArray = this.table;
                    if (this.size() >= this.getMaxEntries()) {
                        this.remove(this.removeItem(), false);
                    }
                    if (entry == entryArray[n2]) {
                        Entry entry3 = null;
                        entry3 = this.memoryCaching ? new Entry(n, object, object2, entry) : new Entry(n, object, NULL, entry);
                        entryArray[n2] = entry3;
                        this.putItem(object);
                        if (bl) {
                            this.persistStore(object, object2);
                        }
                        if (++this.count >= this.threshold) {
                            this.rehash();
                        } else {
                            this.recordModification(entry3);
                        }
                        Entry entry4 = entry3;
                        return entry4;
                    }
                    Object object3 = this.sput(object, object2, n, bl);
                    return object3;
                }
            }
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                AbstractConcurrentReadCache abstractConcurrentReadCache = this;
                synchronized (abstractConcurrentReadCache) {
                    entryArray = this.table;
                    Object object4 = entry2.value;
                    if (entry == entryArray[n2] && object4 != null) {
                        if (this.memoryCaching) {
                            entry2.value = object2;
                        }
                        if (bl) {
                            this.persistStore(object, object2);
                        }
                        this.putItem(object);
                        Object object5 = object4;
                        return object5;
                    }
                    Object object6 = this.sput(object, object2, n, bl);
                    return object6;
                }
            }
            entry2 = entry2.next;
        }
    }

    protected Object sput(Object object, Object object2, int n, boolean bl) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            if (entry2 == null) {
                Entry entry3 = this.memoryCaching ? new Entry(n, object, object2, entry) : new Entry(n, object, NULL, entry);
                this.putItem(object);
                if (bl) {
                    this.persistStore(object, object2);
                }
                entryArray[n2] = entry3;
                if (++this.count >= this.threshold) {
                    this.rehash();
                } else {
                    this.recordModification(entry3);
                }
                return null;
            }
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                Object object3 = entry2.value;
                if (this.memoryCaching) {
                    entry2.value = object2;
                }
                if (bl) {
                    this.persistStore(object, object2);
                }
                this.putItem(object);
                return object3;
            }
            entry2 = entry2.next;
        }
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        if (n >= 0x40000000) {
            return;
        }
        int n2 = n << 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        int n3 = 0;
        while (n3 < n) {
            Entry entry = null;
            Entry entry2 = null;
            Entry entry3 = entryArray[n3];
            while (entry3 != null) {
                int n4 = entry3.hash;
                Entry entry4 = entry3.next;
                if ((n4 & n) == 0) {
                    if (entry == null && (entry4 == null || entry4.next == null && (entry4.hash & n) == 0)) {
                        entry = entry3;
                        break;
                    }
                    entry = new Entry(n4, entry3.key, entry3.value, entry);
                } else {
                    if (entry2 == null && (entry4 == null || entry4.next == null && (entry4.hash & n) != 0)) {
                        entry2 = entry3;
                        break;
                    }
                    entry2 = new Entry(n4, entry3.key, entry3.value, entry2);
                }
                entry3 = entry4;
            }
            entryArray2[n3] = entry;
            entryArray2[n + n3] = entry2;
            ++n3;
        }
        this.table = entryArray2;
        this.recordModification(entryArray2);
    }

    public Object remove(Object object) {
        return this.remove(object, true);
    }

    private Object remove(Object object, boolean bl) {
        Entry entry;
        if (object == null) {
            return null;
        }
        int n = AbstractConcurrentReadCache.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            if (entry2 == null) {
                entryArray = this.getTableForReading();
                if (entry == entryArray[n2]) {
                    return null;
                }
                return this.sremove(object, n, bl);
            }
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                AbstractConcurrentReadCache abstractConcurrentReadCache = this;
                synchronized (abstractConcurrentReadCache) {
                    entryArray = this.table;
                    Object object2 = entry2.value;
                    if (entry != entryArray[n2] || object2 == null) {
                        Object object3 = this.sremove(object, n, bl);
                        return object3;
                    }
                    entry2.value = null;
                    --this.count;
                    if (!this.unlimitedDiskCache) {
                        this.persistRemove(entry2.key);
                    }
                    if (bl) {
                        this.removeItem(object);
                    }
                    Entry entry3 = entry2.next;
                    Entry entry4 = entry;
                    while (entry4 != entry2) {
                        entry3 = new Entry(entry4.hash, entry4.key, entry4.value, entry3);
                        entry4 = entry4.next;
                    }
                    entryArray[n2] = entry3;
                    this.recordModification(entry3);
                    Object object4 = object2;
                    return object4;
                }
            }
            entry2 = entry2.next;
        }
    }

    protected Object sremove(Object object, int n, boolean bl) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                Object object2 = entry2.value;
                entry2.value = null;
                --this.count;
                if (!this.unlimitedDiskCache) {
                    this.persistRemove(entry2.key);
                }
                if (bl) {
                    this.removeItem(object);
                }
                Entry entry3 = entry2.next;
                Entry entry4 = entry;
                while (entry4 != entry2) {
                    entry3 = new Entry(entry4.hash, entry4.key, entry4.value, entry3);
                    entry4 = entry4.next;
                }
                entryArray[n2] = entry3;
                this.recordModification(entry3);
                return object2;
            }
            entry2 = entry2.next;
        }
        return null;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.getTableForReading();
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            while (entry != null) {
                Object object2 = entry.value;
                if (object2 != null && object.equals(object2)) {
                    return true;
                }
                entry = entry.next;
            }
            ++n;
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public synchronized void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.put(k, v);
        }
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            while (entry != null) {
                entry.value = null;
                this.persistRemove(entry.key);
                this.removeItem(entry.key);
                entry = entry.next;
            }
            entryArray[n] = null;
            ++n;
        }
        this.count = 0;
        this.recordModification(entryArray);
    }

    public synchronized Object clone() {
        try {
            AbstractConcurrentReadCache abstractConcurrentReadCache = (AbstractConcurrentReadCache)super.clone();
            abstractConcurrentReadCache.keySet = null;
            abstractConcurrentReadCache.entrySet = null;
            abstractConcurrentReadCache.values = null;
            Entry[] entryArray = this.table;
            Entry[] entryArray2 = abstractConcurrentReadCache.table = new Entry[entryArray.length];
            int n = 0;
            while (n < entryArray.length) {
                Entry entry = entryArray[n];
                if (entry != null) {
                    entryArray2[n] = (Entry)entry.clone();
                }
                ++n;
            }
            return abstractConcurrentReadCache;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        Set set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new AbstractSet(){

            public Iterator iterator() {
                return new KeyIterator();
            }

            public int size() {
                return AbstractConcurrentReadCache.this.size();
            }

            public boolean contains(Object object) {
                return AbstractConcurrentReadCache.this.containsKey(object);
            }

            public boolean remove(Object object) {
                return AbstractConcurrentReadCache.this.remove(object) != null;
            }

            public void clear() {
                AbstractConcurrentReadCache.this.clear();
            }
        };
        return this.keySet;
    }

    public Collection values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new AbstractCollection(){

            public Iterator iterator() {
                return new ValueIterator();
            }

            public int size() {
                return AbstractConcurrentReadCache.this.size();
            }

            public boolean contains(Object object) {
                return AbstractConcurrentReadCache.this.containsValue(object);
            }

            public void clear() {
                AbstractConcurrentReadCache.this.clear();
            }
        };
        return this.values;
    }

    public Set entrySet() {
        Set set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new AbstractSet(){

            public Iterator iterator() {
                return new HashIterator();
            }

            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object object2 = AbstractConcurrentReadCache.this.get(k);
                return object2 != null && object2.equals(entry.getValue());
            }

            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                return AbstractConcurrentReadCache.this.findAndRemoveEntry((Map.Entry)object);
            }

            public int size() {
                return AbstractConcurrentReadCache.this.size();
            }

            public void clear() {
                AbstractConcurrentReadCache.this.clear();
            }
        };
        return this.entrySet;
    }

    protected synchronized boolean findAndRemoveEntry(Map.Entry entry) {
        Object k = entry.getKey();
        Object object = this.get(k);
        if (object != null && object.equals(entry.getValue())) {
            this.remove(k);
            return true;
        }
        return false;
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    protected synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        int n = this.table.length - 1;
        while (n >= 0) {
            Entry entry = this.table[n];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
            --n;
        }
    }

    protected synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        int n2 = objectInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            ++n3;
        }
    }

    public synchronized int capacity() {
        return this.table.length;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    protected class ValueIterator
    extends HashIterator {
        protected ValueIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentValue;
        }
    }

    protected class KeyIterator
    extends HashIterator {
        protected KeyIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentKey;
        }
    }

    protected class HashIterator
    implements Iterator,
    Enumeration {
        protected final Entry[] tab;
        protected int index;
        protected Entry entry = null;
        protected Object currentKey;
        protected Object currentValue;
        protected Entry lastReturned = null;

        protected HashIterator() {
            this.tab = AbstractConcurrentReadCache.this.getTableForReading();
            this.index = this.tab.length - 1;
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }

        public boolean hasNext() {
            do {
                if (this.entry != null) {
                    Object object = this.entry.value;
                    if (object != null) {
                        this.currentKey = this.entry.key;
                        this.currentValue = object;
                        return true;
                    }
                    this.entry = this.entry.next;
                }
                while (this.entry == null && this.index >= 0) {
                    this.entry = this.tab[this.index--];
                }
            } while (this.entry != null);
            this.currentValue = null;
            this.currentKey = null;
            return false;
        }

        protected Object returnValueOfNext() {
            return this.entry;
        }

        public Object next() {
            if (this.currentKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.returnValueOfNext();
            this.lastReturned = this.entry;
            this.currentValue = null;
            this.currentKey = null;
            this.entry = this.entry.next;
            return object;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            AbstractConcurrentReadCache.this.remove(this.lastReturned.key);
        }
    }

    protected static class Entry
    implements Map.Entry {
        protected final int hash;
        protected final Object key;
        protected final Entry next;
        protected volatile Object value;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.next = entry;
            this.value = object2;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (!this.key.equals(entry.getKey())) {
                return false;
            }
            Object object2 = this.value;
            return object2 == null ? entry.getValue() == null : object2.equals(entry.getValue());
        }

        public int hashCode() {
            Object object = this.value;
            return this.hash ^ (object == null ? 0 : object.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

