/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.oscache.web;

import com.opensymphony.module.oscache.base.AbstractCacheAdministrator;
import com.opensymphony.module.oscache.base.Cache;
import com.opensymphony.module.oscache.base.CacheEntry;
import com.opensymphony.module.oscache.base.EntryRefreshPolicy;
import com.opensymphony.module.oscache.base.NeedsRefreshException;
import com.opensymphony.module.oscache.base.events.ScopeEvent;
import com.opensymphony.module.oscache.base.events.ScopeEventListener;
import com.opensymphony.module.oscache.base.events.ScopeEventType;
import com.opensymphony.module.oscache.base.persistence.DiskPersistenceListener;
import com.opensymphony.module.oscache.web.ServletCache;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public final class ServletCacheAdministrator
extends AbstractCacheAdministrator
implements Serializable {
    private static final String APPLICATION_CACHE_SUBPATH = "application";
    private static final String SESSION_CACHE_SUBPATH = "session";
    private static final String CACHE_USE_HOST_DOMAIN_KEY = "cache.useHostDomainInKey";
    private static final String CACHE_KEY_KEY = "cache.key";
    public static final String SESSION_SCOPE_NAME = "session";
    public static final String APPLICATION_SCOPE_NAME = "application";
    private static final String CACHE_ADMINISTRATOR_KEY = "__oscache_admin";
    private static final short AVERAGE_KEY_LENGTH = 30;
    private boolean useHostDomainInKey = false;
    private String cacheKey;
    private Map flushTimes = new HashMap();
    private static final String m_strBase64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static Map cacheAdministrators = new WeakHashMap();
    private static Map sessionCaches = new WeakHashMap();
    private static Map applicationCaches = new WeakHashMap();
    private WeakReference contextRef;
    static /* synthetic */ Class class$com$opensymphony$module$oscache$base$events$ScopeEventListener;

    private ServletCacheAdministrator(ServletContext servletContext) {
        this.contextRef = new WeakReference<ServletContext>(servletContext);
        this.initHostDomainInKey();
        this.log("Constructed ServletCacheAdministrator()");
    }

    public static ServletCacheAdministrator getInstance(ServletContext servletContext) {
        ServletCacheAdministrator servletCacheAdministrator = null;
        servletCacheAdministrator = (ServletCacheAdministrator)cacheAdministrators.get(servletContext);
        if (servletCacheAdministrator == null) {
            servletCacheAdministrator = new ServletCacheAdministrator(servletContext);
            cacheAdministrators.put(servletContext, servletCacheAdministrator);
            servletCacheAdministrator.log("getInstance(): Created new instance of ServletCacheAdministrator");
        }
        return servletCacheAdministrator;
    }

    public static Map getSessionCaches() {
        return sessionCaches;
    }

    public static Map getApplicationCaches() {
        return applicationCaches;
    }

    public String generateEntryKey(String string, HttpServletRequest httpServletRequest, int n) {
        return this.generateEntryKey(string, httpServletRequest, n, null, null);
    }

    public String generateEntryKey(String string, HttpServletRequest httpServletRequest, int n, String string2) {
        return this.generateEntryKey(string, httpServletRequest, n, string2, null);
    }

    public String generateEntryKey(String string, HttpServletRequest httpServletRequest, int n, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(30);
        if (string2 != null) {
            stringBuffer.append(AbstractCacheAdministrator.FILE_SEPARATOR).append(string2);
        }
        if (this.useHostDomainInKey) {
            stringBuffer.append(AbstractCacheAdministrator.FILE_SEPARATOR).append(httpServletRequest.getServerName());
        }
        if (string != null) {
            stringBuffer.append(AbstractCacheAdministrator.FILE_SEPARATOR).append(string);
        } else {
            String string4 = httpServletRequest.getRequestURI().replace('/', AbstractCacheAdministrator.FILE_SEPARATOR_CHAR);
            if (string4.charAt(0) != AbstractCacheAdministrator.FILE_SEPARATOR_CHAR) {
                stringBuffer.append(AbstractCacheAdministrator.FILE_SEPARATOR_CHAR);
            }
            stringBuffer.append(string4);
            string4 = httpServletRequest.getQueryString();
            if (string4 != null) {
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                    byte[] byArray = messageDigest.digest(string4.getBytes());
                    stringBuffer.append("_");
                    stringBuffer.append(ServletCacheAdministrator.toBase64(byArray).replace('/', '_'));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string4 = null;
            }
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static String toBase64(byte[] byArray) {
        int n = byArray.length;
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            boolean bl = n2 + 1 < n;
            boolean bl2 = n2 + 2 < n;
            int n3 = byArray[n2] & 0xFF;
            int n4 = bl ? byArray[n2 + 1] & 0xFF : 0;
            int n5 = bl2 ? byArray[n2 + 2] & 0xFF : 0;
            string = string + m_strBase64Chars.charAt(n3 / 4);
            string = string + m_strBase64Chars.charAt(n4 / 16 + (n3 & 3) * 16);
            string = string + (bl ? m_strBase64Chars.charAt(n5 / 64 + (n4 & 0xF) * 4) : (char)'=');
            string = string + (bl2 ? m_strBase64Chars.charAt(n5 & 0x3F) : (char)'=');
            n2 += 3;
        }
        return string;
    }

    private void initHostDomainInKey() {
        String string = this.getProperty(CACHE_USE_HOST_DOMAIN_KEY);
        this.useHostDomainInKey = string != null && string.equalsIgnoreCase("true");
    }

    public Cache getCache(HttpServletRequest httpServletRequest, int n) {
        Cache cache = null;
        Object var4_4 = null;
        if (n == 4) {
            var4_4 = applicationCaches.get(this.contextRef.get());
        } else if (n == 3) {
            var4_4 = sessionCaches.get(httpServletRequest.getSession());
        } else {
            throw new RuntimeException("Invalid scope");
        }
        if (var4_4 == null || !(var4_4 instanceof Cache)) {
            this.log("Created new Cache at key: " + this.getCacheKey());
            if (n == 4) {
                cache = this.createCache(n, null);
                applicationCaches.put(this.contextRef.get(), cache);
            } else if (n == 3) {
                cache = this.createCache(n, httpServletRequest.getSession(false).getId());
                sessionCaches.put(httpServletRequest.getSession(), cache);
            }
        } else {
            cache = var4_4;
        }
        return cache;
    }

    private ServletCache createCache(int n, String string) {
        this.log("Created new cache in scope " + n);
        ServletCache servletCache = new ServletCache(this, this.algorithmClass, this.cacheCapacity, n);
        if (this.isFileCaching()) {
            StringBuffer stringBuffer = new StringBuffer(this.getCachePath().getPath());
            stringBuffer.append("/");
            stringBuffer.append(this.getPathPart(n));
            if (string != null && string.length() > 0) {
                stringBuffer.append("/");
                stringBuffer.append(string);
            }
            servletCache.setPersistenceListener(new DiskPersistenceListener(stringBuffer.toString()));
        }
        return servletCache;
    }

    public String getCacheKey() {
        if (this.cacheKey == null) {
            this.cacheKey = this.getProperty(CACHE_KEY_KEY);
            if (this.cacheKey == null) {
                this.cacheKey = "__oscache_cache";
            }
        }
        return this.cacheKey;
    }

    public void logError(String string) {
        System.out.println("[oscache]: " + string);
    }

    public Object getFromCache(int n, HttpServletRequest httpServletRequest, String string, int n2) throws NeedsRefreshException {
        Cache cache = this.getCache(httpServletRequest, n);
        string = this.generateEntryKey(string, httpServletRequest, n);
        return cache.getFromCache(string, n2);
    }

    public void putInCache(int n, HttpServletRequest httpServletRequest, String string, Object object) {
        this.putInCache(n, httpServletRequest, string, object, null);
    }

    public void putInCache(int n, HttpServletRequest httpServletRequest, String string, Object object, EntryRefreshPolicy entryRefreshPolicy) {
        Cache cache = this.getCache(httpServletRequest, n);
        string = this.generateEntryKey(string, httpServletRequest, n);
        cache.putInCache(string, object, entryRefreshPolicy);
    }

    private String getPathPart(int n) {
        if (n == 3) {
            return "session";
        }
        return "application";
    }

    public boolean isScopeFlushed(CacheEntry cacheEntry, int n) {
        Date date = this.getFlushTime(n);
        this.log("Scope " + n + " flushed at " + date);
        if (date != null) {
            long l = cacheEntry.getLastUpdate();
            this.log("Cache updated at " + new Date(l));
            return date.getTime() >= l;
        }
        return false;
    }

    public void setFlushTime(Date date, int n) {
        this.log("Flushing scope " + n + " at " + date);
        Map map = this.flushTimes;
        synchronized (map) {
            if (date == null) {
                this.logError("setFlushTime called with a null date.");
                throw new IllegalArgumentException("setFlushTime called with a null date.");
            }
            this.dispatchScopeEvent(ScopeEventType.SCOPE_FLUSHED, n, date);
            this.flushTimes.put(new Integer(n), date);
        }
    }

    public void setFlushTime(int n) {
        this.setFlushTime(new Date(), n);
    }

    public void flushAll(Date date) {
        Map map = this.flushTimes;
        synchronized (map) {
            this.dispatchScopeEvent(ScopeEventType.ALL_SCOPE_FLUSHED, -1, date);
            this.setFlushTime(date, 4);
            this.setFlushTime(date, 3);
            this.setFlushTime(date, 2);
            this.setFlushTime(date, 1);
        }
    }

    public void flushAll() {
        this.flushAll(new Date());
    }

    public Date getFlushTime(int n) {
        Map map = this.flushTimes;
        synchronized (map) {
            Date date = (Date)this.flushTimes.get(new Integer(n));
            return date;
        }
    }

    public void addScopeEventListener(ScopeEventListener scopeEventListener) {
        this.listenerList.add(class$com$opensymphony$module$oscache$base$events$ScopeEventListener == null ? (class$com$opensymphony$module$oscache$base$events$ScopeEventListener = ServletCacheAdministrator.class$("com.opensymphony.module.oscache.base.events.ScopeEventListener")) : class$com$opensymphony$module$oscache$base$events$ScopeEventListener, scopeEventListener);
    }

    public void removeScopeEventListener(ScopeEventListener scopeEventListener) {
        this.listenerList.remove(class$com$opensymphony$module$oscache$base$events$ScopeEventListener == null ? (class$com$opensymphony$module$oscache$base$events$ScopeEventListener = ServletCacheAdministrator.class$("com.opensymphony.module.oscache.base.events.ScopeEventListener")) : class$com$opensymphony$module$oscache$base$events$ScopeEventListener, scopeEventListener);
    }

    public void dispatchScopeEvent(ScopeEventType scopeEventType, int n, Date date) {
        ScopeEvent scopeEvent = new ScopeEvent(scopeEventType, n, date);
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$com$opensymphony$module$oscache$base$events$ScopeEventListener == null ? ServletCacheAdministrator.class$("com.opensymphony.module.oscache.base.events.ScopeEventListener") : class$com$opensymphony$module$oscache$base$events$ScopeEventListener)) {
                ((ScopeEventListener)objectArray[n2 + 1]).scopeFlushed(scopeEvent);
            }
            n2 -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

