/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import java.util.Arrays;

final class Base64 {
    private static final String BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final int[] BASE64_DECODE_MAP = new int[256];

    private Base64() {
    }

    public static char toBase64(int value) {
        assert (value <= 63 && value >= 0) : "value out of range:" + value;
        return BASE64_MAP.charAt(value);
    }

    public static int fromBase64(char c) {
        int result = BASE64_DECODE_MAP[c];
        assert (result != -1) : "invalid char";
        return BASE64_DECODE_MAP[c];
    }

    static {
        Arrays.fill(BASE64_DECODE_MAP, -1);
        for (int i = 0; i < BASE64_MAP.length(); ++i) {
            Base64.BASE64_DECODE_MAP[BASE64_MAP.charAt((int)i)] = i;
        }
    }
}

