/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SafeSaxParserSaxSourceFactory {
    private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));
    private static EntityResolver emptyEntityResolver = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return EMPTY_INPUT_SOURCE;
        }
    };

    public static SAXSource createSafeSaxParserSource(InputStream entityStream) {
        return SafeSaxParserSaxSourceFactory.createSafeSaxParserSource(SAXParserFactory.newInstance(), entityStream);
    }

    public static SAXSource createSafeSaxParserSource(SAXParserFactory parserFactory, InputStream entityStream) {
        try {
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(false);
            parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            XMLReader xmlReader = parserFactory.newSAXParser().getXMLReader();
            xmlReader.setEntityResolver(emptyEntityResolver);
            return new SAXSource(xmlReader, new InputSource(entityStream));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

