/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.xml;

import com.sun.jersey.core.impl.provider.xml.ThreadLocalSingletonContextProvider;
import com.sun.jersey.core.util.FeaturesAndProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.Context;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;

public class XMLStreamReaderContextProvider
extends ThreadLocalSingletonContextProvider<XMLInputFactory> {
    private final boolean disableXmlSecurity;
    private static final InputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    private static XMLResolver emptyEntityResolver = new XMLResolver(){

        @Override
        public Object resolveEntity(String publicId, String systemId, String baseURI, String namespace) throws XMLStreamException {
            return EMPTY_INPUT_STREAM;
        }
    };

    public XMLStreamReaderContextProvider(@Context FeaturesAndProperties fps) {
        super(XMLInputFactory.class);
        this.disableXmlSecurity = fps.getFeature("com.sun.jersey.config.feature.DisableXmlSecurity");
    }

    @Override
    protected XMLInputFactory getInstance() {
        XMLInputFactory f = XMLInputFactory.newInstance();
        if (!this.disableXmlSecurity) {
            f.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            f.setXMLResolver(emptyEntityResolver);
        }
        return f;
    }
}

