/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fugue;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Functions;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Either<L, R> {
    public static <L, R> Either<L, R> left(L left) {
        Preconditions.checkNotNull(left);
        return new Left(left);
    }

    public static <L, R> Either<L, R> right(R right) {
        Preconditions.checkNotNull(right);
        return new Right(right);
    }

    public static <T> T merge(Either<T, T> either) {
        if (either.isLeft()) {
            return (T)either.left().get();
        }
        return (T)either.right().get();
    }

    public static <L, R> Either<L, R> cond(boolean predicate, R right, L left) {
        return predicate ? Either.right(right) : Either.left(left);
    }

    public static <X extends Exception, A> A getOrThrow(Either<X, A> either) throws X {
        if (either.isLeft()) {
            throw (Exception)either.left().get();
        }
        return (A)either.right().get();
    }

    Either() {
    }

    public boolean isLeft() {
        return false;
    }

    public boolean isRight() {
        return false;
    }

    public final LeftProjection left() {
        return new LeftProjection();
    }

    public final RightProjection right() {
        return new RightProjection();
    }

    L getLeft() {
        throw new NoSuchElementException();
    }

    R getRight() {
        throw new NoSuchElementException();
    }

    public abstract Either<R, L> swap();

    public abstract <V> V fold(Function<? super L, V> var1, Function<? super R, V> var2);

    public static interface Projection<A, B, L, R>
    extends Maybe<A> {
        public Either<L, R> either();

        public Option<A> toOption();

        public A on(Function<? super B, A> var1);
    }

    public final class RightProjection
    implements Projection<R, L, L, R> {
        private RightProjection() {
        }

        @Override
        public Iterator<R> iterator() {
            return this.toOption().iterator();
        }

        @Override
        public Either<L, R> either() {
            return Either.this;
        }

        @Override
        public R getOrError(Supplier<String> err) {
            return this.toOption().getOrError(err);
        }

        @Override
        public R get() {
            return Either.this.getRight();
        }

        @Override
        public boolean isDefined() {
            return Either.this.isRight();
        }

        @Override
        public boolean isEmpty() {
            return !this.isDefined();
        }

        @Override
        public R getOrElse(Supplier<R> b) {
            return Either.this.isRight() ? this.get() : b.get();
        }

        @Override
        public <X extends R> R getOrElse(X x) {
            return Either.this.isRight() ? this.get() : x;
        }

        @Override
        public R getOrNull() {
            return Either.this.isRight() ? (Object)this.get() : null;
        }

        @Override
        public void foreach(Effect<R> f) {
            if (Either.this.isRight()) {
                f.apply(this.get());
            }
        }

        @Override
        public boolean forall(Predicate<R> f) {
            return Either.this.isLeft() || f.apply(this.get());
        }

        @Override
        public boolean exists(Predicate<R> f) {
            return Either.this.isRight() && f.apply(this.get());
        }

        @Override
        public Option<R> toOption() {
            return Either.this.isRight() ? Option.some(this.get()) : Option.none();
        }

        @Override
        public R on(Function<? super L, R> f) {
            return Either.this.isRight() ? this.get() : f.apply(Either.this.left().get());
        }

        public <X> Either<L, X> map(Function<? super R, X> f) {
            return Either.this.isRight() ? new Right(f.apply(this.get())) : this.toLeft();
        }

        <X> Left<L, X> toLeft() {
            return new Left(Either.this.left().get());
        }

        public <X> Either<L, X> flatMap(Function<R, Either<L, X>> f) {
            return Either.this.isRight() ? (Either)f.apply(this.get()) : new Left(Either.this.left().get());
        }

        public <X> Either<L, X> sequence(Either<L, X> e) {
            return this.flatMap(Functions.constant(e));
        }

        public <X> Option<Either<X, R>> filter(Predicate<R> f) {
            if (Either.this.isRight() && f.apply(this.get())) {
                return Option.some(new Right(this.get()));
            }
            return Option.none();
        }

        public <X> Either<L, X> apply(Either<L, Function<R, X>> either) {
            return either.right().flatMap(new Function<Function<R, X>, Either<L, X>>(){

                public Either<L, X> apply(Function<R, X> f) {
                    return RightProjection.this.map(f);
                }
            });
        }
    }

    public final class LeftProjection
    implements Projection<L, R, L, R> {
        private LeftProjection() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public Iterator<L> iterator() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public Either<L, R> either() {
            return Either.this;
        }

        @Override
        public L get() {
            return Either.this.getLeft();
        }

        @Override
        public L getOrNull() {
            return Either.this.isLeft() ? (Object)this.get() : null;
        }

        @Override
        public boolean isDefined() {
            return Either.this.isLeft();
        }

        @Override
        public boolean isEmpty() {
            return !this.isDefined();
        }

        @Override
        public L getOrError(Supplier<String> err) {
            return this.toOption().getOrError(err);
        }

        @Override
        public L getOrElse(Supplier<L> a) {
            return Either.this.isLeft() ? this.get() : a.get();
        }

        @Override
        public <X extends L> L getOrElse(X x) {
            return Either.this.isLeft() ? this.get() : x;
        }

        @Override
        public void foreach(Effect<L> f) {
            if (Either.this.isLeft()) {
                f.apply(this.get());
            }
        }

        @Override
        public boolean forall(Predicate<L> f) {
            return Either.this.isRight() || f.apply(this.get());
        }

        @Override
        public boolean exists(Predicate<L> f) {
            return Either.this.isLeft() && f.apply(this.get());
        }

        @Override
        public Option<L> toOption() {
            return Either.this.isLeft() ? Option.some(this.get()) : Option.none();
        }

        @Override
        public L on(Function<? super R, L> f) {
            return Either.this.isLeft() ? this.get() : f.apply(Either.this.right().get());
        }

        public <X> Either<X, R> map(Function<? super L, X> f) {
            return Either.this.isLeft() ? new Left(f.apply(this.get())) : new Right(Either.this.right().get());
        }

        public <X> Either<X, R> flatMap(Function<? super L, Either<X, R>> f) {
            return Either.this.isLeft() ? (Either)f.apply(this.get()) : new Right(Either.this.getRight());
        }

        public <X> Either<X, R> sequence(Either<X, R> e) {
            return this.flatMap(Functions.constant(e));
        }

        public <X> Option<Either<L, X>> filter(Predicate<L> f) {
            if (Either.this.isLeft() && f.apply(this.get())) {
                return Option.some(new Left(this.get()));
            }
            return Option.none();
        }

        public <X> Either<X, R> apply(Either<Function<L, X>, R> either) {
            return either.left().flatMap(new Function<Function<L, X>, Either<X, R>>(){

                public Either<X, R> apply(Function<L, X> f) {
                    return LeftProjection.this.map(f);
                }
            });
        }
    }

    static final class Right<L, R>
    extends Either<L, R> {
        private final R value;

        public Right(R value) {
            Preconditions.checkNotNull(value);
            this.value = value;
        }

        @Override
        final R getRight() {
            return this.value;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public Either<R, L> swap() {
            return Right.left(this.value);
        }

        @Override
        public <V> V fold(Function<? super L, V> ifLeft, Function<? super R, V> ifRight) {
            return (V)ifRight.apply(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Right)) {
                return false;
            }
            return this.value.equals(((Right)o).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "Either.Right(" + this.value.toString() + ")";
        }
    }

    static final class Left<L, R>
    extends Either<L, R> {
        private final L value;

        public Left(L value) {
            Preconditions.checkNotNull(value);
            this.value = value;
        }

        @Override
        final L getLeft() {
            return this.value;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public Either<R, L> swap() {
            return Left.right(this.value);
        }

        @Override
        public <V> V fold(Function<? super L, V> ifLeft, Function<? super R, V> ifRight) {
            return (V)ifLeft.apply(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Left)) {
                return false;
            }
            return this.value.equals(((Left)o).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "Either.Left(" + this.value.toString() + ")";
        }
    }
}

