/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fugue.retry;

import com.atlassian.fugue.retry.ExceptionHandler;
import com.atlassian.fugue.retry.ExceptionHandlers;
import com.atlassian.fugue.retry.NoOpBeforeRetryTask;
import com.atlassian.fugue.retry.RetrySupplier;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;

public class RetryFunction<F, T>
implements Function<F, T> {
    private final Function<F, T> function;
    private final int tries;
    private final ExceptionHandler handler;
    private final Runnable beforeRetry;

    public RetryFunction(Function<F, T> function, int tries) {
        this(function, tries, ExceptionHandlers.ignoreExceptionHandler());
    }

    public RetryFunction(Function<F, T> function, int tries, ExceptionHandler handler) {
        this(function, tries, handler, new NoOpBeforeRetryTask());
    }

    public RetryFunction(Function<F, T> function, int tries, ExceptionHandler handler, Runnable beforeRetry) {
        this.beforeRetry = beforeRetry;
        Preconditions.checkNotNull(function);
        Preconditions.checkArgument((tries >= 0 ? 1 : 0) != 0, (Object)"Tries must not be negative");
        Preconditions.checkNotNull((Object)handler);
        this.function = function;
        this.tries = tries;
        this.handler = handler;
    }

    public T apply(F parameter) {
        return new RetrySupplier(Suppliers.compose(this.function, (Supplier)Suppliers.ofInstance(parameter)), this.tries, this.handler, this.beforeRetry).get();
    }
}

