/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.ampsdispatcher;

import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.util.VersionUtils;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractAmpsDispatcherMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    MavenSession session;
    @Component
    BuildPluginManager buildPluginManager;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        String targetArtifactId = this.detectAmpsProduct();
        if (targetArtifactId == null || this.session.getGoals().size() <= 0) {
            throw new MojoFailureException("Couldn't detect an AMPS product to dispatch to");
        }
        String goal = this.determineGoal();
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.atlassian.maven.plugins"), (String)MojoExecutor.artifactId((String)targetArtifactId), (String)MojoExecutor.version((String)VersionUtils.getVersion())), (String)MojoExecutor.goal((String)goal), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]), (MojoExecutor.ExecutionEnvironment)this.getExecutionEnvironment());
    }

    final String determineGoal() {
        String goal = (String)this.session.getGoals().get(0);
        goal = goal.substring(goal.lastIndexOf(":") + 1);
        return goal;
    }

    final String detectAmpsProduct() {
        List buildPlugins = this.project.getBuildPlugins();
        HashSet<String> possiblePluginTypes = new HashSet<String>(ProductHandlerFactory.getIds());
        possiblePluginTypes.add("amps");
        if (buildPlugins != null) {
            for (Plugin pomPlugin : buildPlugins) {
                if (!"com.atlassian.maven.plugins".equals(pomPlugin.getGroupId())) continue;
                for (String type : possiblePluginTypes) {
                    if (!("maven-" + type + "-plugin").equals(pomPlugin.getArtifactId())) continue;
                    return pomPlugin.getArtifactId();
                }
            }
        }
        return null;
    }

    protected MojoExecutor.ExecutionEnvironment getExecutionEnvironment() {
        return MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.buildPluginManager);
    }
}

