

@echo off
if "%OS%" == "Windows_NT" setlocal enableextensions enabledelayedexpansion



rem ---------------------------------------------------------------
rem Check for help command
rem ---------------------------------------------------------------

if /I "%1"=="help" goto showhelp
if /I "%1"=="-?" goto showhelp
if /I "%1"=="-h" goto showhelp
if /I "%1"=="-help" goto showhelp
if /I "%1"=="--help" goto showhelp
if /I "%1"=="/?" goto showhelp
if /I "%1"=="/h" goto showhelp
if /I "%1"=="/help" goto showhelp

goto continue

:showhelp
echo.
echo Usage: atlas-create-confluence-plugin [options]
echo.
echo Creates a Confluence plugin.
    echo.
    echo The following options are available:
                                        echo -a [value], --artifact-id [value]
                            echo     Name of the project (corresponds to the Maven artifactId).
        echo.
                                        echo -g [value], --group-id [value]
                            echo     Identifier for the logical group of artifacts associated with the project (corresponds to the Maven groupId).
        echo.
                                        echo -v [value], --version [value]
                            echo     Version of the project (default is 1.0-SNAPSHOT).
        echo.
                                        echo -p [value], --package [value]
                            echo     Java package that will contain the plugin source code (default is group-id value).
        echo.
                                        echo --non-interactive
                            echo     Does not prompt the user for input. Turns off interactive mode.
        echo.
    goto end

:continue

rem ---------------------------------------------------------------
rem Find absolute path to the program
rem ---------------------------------------------------------------

set PRGDIR=%~dp0
set CURRENTDIR=%cd%
cd /d %PRGDIR%..
set ATLAS_HOME=%cd%
cd /d %CURRENTDIR%


rem ---------------------------------------------------------------
rem Identify Maven location relative to script
rem ---------------------------------------------------------------

set MVN2_HOME=%ATLAS_HOME%\apache-maven-3.2.1
set MAVEN_EXECUTABLE="%MVN2_HOME%\bin\mvn.bat"
set ATLAS_VERSION="5.0.18"

if not "%ATLAS_MVN%"=="" set MAVEN_EXECUTABLE="%ATLAS_MVN%"


rem Check that the target executable exists

if not exist "!MAVEN_EXECUTABLE!" (
	echo Cannot find %MAVEN_EXECUTABLE%
	echo This file is needed to run this program
	goto end
)



rem ---------------------------------------------------------------
rem Transform Parameters into Maven Parameters
rem
rem NOTE: in DOS, all the 'else' statements must be on the same
rem line as the closing bracket for the 'if' statement.
rem ---------------------------------------------------------------

set ARGV=.%*
call :parse_argv
if ERRORLEVEL 1 (
  echo Cannot parse arguments
  endlocal
  exit /B 1
)

set MAVEN_OPTS=-Xmx768M -XX:MaxPermSize=256M %ATLAS_OPTS%
set MVN_PARAMS=-gs %MVN2_HOME%/conf/settings.xml

set ARGI = 0

:loopstart
set /a ARGI = !ARGI! + 1
set /a ARGN = !ARGI! + 1

if !ARGI! gtr %ARGC% goto loopend

call :getarg !ARGI! ARG
call :getarg !ARGN! ARGNEXT

    if /I "%ARG%"=="--artifact-id" (
                    set MVN_PARAMS=%MVN_PARAMS% -DartifactId=%ARGNEXT%
            set /a ARGI = !ARGI! + 1
                goto loopstart
    )  else (
            if /I "%ARG%"=="-a" (
                                    set MVN_PARAMS=%MVN_PARAMS% -DartifactId=%ARGNEXT%
                    set /a ARGI = !ARGI! + 1
                                goto loopstart
            )  else (
    if /I "%ARG%"=="--group-id" (
                    set MVN_PARAMS=%MVN_PARAMS% -DgroupId=%ARGNEXT%
            set /a ARGI = !ARGI! + 1
                goto loopstart
    )  else (
            if /I "%ARG%"=="-g" (
                                    set MVN_PARAMS=%MVN_PARAMS% -DgroupId=%ARGNEXT%
                    set /a ARGI = !ARGI! + 1
                                goto loopstart
            )  else (
    if /I "%ARG%"=="--version" (
                    set MVN_PARAMS=%MVN_PARAMS% -Dversion=%ARGNEXT%
            set /a ARGI = !ARGI! + 1
                goto loopstart
    )  else (
            if /I "%ARG%"=="-v" (
                                    set MVN_PARAMS=%MVN_PARAMS% -Dversion=%ARGNEXT%
                    set /a ARGI = !ARGI! + 1
                                goto loopstart
            )  else (
    if /I "%ARG%"=="--package" (
                    set MVN_PARAMS=%MVN_PARAMS% -Dpackage=%ARGNEXT%
            set /a ARGI = !ARGI! + 1
                goto loopstart
    )  else (
            if /I "%ARG%"=="-p" (
                                    set MVN_PARAMS=%MVN_PARAMS% -Dpackage=%ARGNEXT%
                    set /a ARGI = !ARGI! + 1
                                goto loopstart
            )  else (
    if /I "%ARG%"=="--non-interactive" (
                    set MVN_PARAMS=%MVN_PARAMS% -DinteractiveMode=false            
                goto loopstart
    )  else (

set MVN_PARAMS=%MVN_PARAMS% %ARG%
shift
goto loopstart

        )
        )
        )
        )
        )
        )
        )
        )
        )
    :loopend


rem ---------------------------------------------------------------
rem Executing Maven
rem ---------------------------------------------------------------

echo Executing: %MAVEN_EXECUTABLE% com.atlassian.maven.plugins:maven-confluence-plugin:5.0.18:create %MVN_PARAMS%
%MAVEN_EXECUTABLE% com.atlassian.maven.plugins:maven-confluence-plugin:5.0.18:create %MVN_PARAMS%

rem ---------------------------------------------------------------
rem (AMPS-197) The batch routines below for correct handling 
rem parameters containing of = and ; are from Skypher's excellent 
rem blog: 
rem http://skypher.com/index.php/2010/08/17/batch-command-line-arguments/
rem ---------------------------------------------------------------

:parse_argv
  SET PARSE_ARGV_ARG=[]
  SET PARSE_ARGV_END=FALSE
  SET PARSE_ARGV_INSIDE_QUOTES=FALSE
  SET /A ARGC = 0
  SET /A PARSE_ARGV_INDEX=1
  :PARSE_ARGV_LOOP
  CALL :PARSE_ARGV_CHAR !PARSE_ARGV_INDEX! "%%ARGV:~!PARSE_ARGV_INDEX!,1%%"
  IF ERRORLEVEL 1 (
    EXIT /B 1
  )
  IF !PARSE_ARGV_END! == TRUE (
    EXIT /B 0
  )
  SET /A PARSE_ARGV_INDEX=!PARSE_ARGV_INDEX! + 1
  GOTO :PARSE_ARGV_LOOP
 
  :PARSE_ARGV_CHAR
    IF ^%~2 == ^" (
      SET PARSE_ARGV_END=FALSE
      SET PARSE_ARGV_ARG=.%PARSE_ARGV_ARG:~1,-1%%~2.
      IF !PARSE_ARGV_INSIDE_QUOTES! == TRUE (
        SET PARSE_ARGV_INSIDE_QUOTES=FALSE
      ) ELSE (
        SET PARSE_ARGV_INSIDE_QUOTES=TRUE
      )
      EXIT /B 0
    )
    IF %2 == "" (
      IF !PARSE_ARGV_INSIDE_QUOTES! == TRUE (
        EXIT /B 1
      )
      SET PARSE_ARGV_END=TRUE
    ) ELSE IF NOT "%~2!PARSE_ARGV_INSIDE_QUOTES!" == " FALSE" (
      SET PARSE_ARGV_ARG=[%PARSE_ARGV_ARG:~1,-1%%~2]
      EXIT /B 0
    )
    IF NOT !PARSE_ARGV_INDEX! == 1 (
      SET /A ARGC = !ARGC! + 1
      SET ARG!ARGC!=%PARSE_ARGV_ARG:~1,-1%
      IF ^%PARSE_ARGV_ARG:~1,1% == ^" (
        SET ARG!ARGC!_=%PARSE_ARGV_ARG:~2,-2%
        SET ARG!ARGC!Q=%PARSE_ARGV_ARG:~1,-1%
      ) ELSE (
        SET ARG!ARGC!_=%PARSE_ARGV_ARG:~1,-1%
        SET ARG!ARGC!Q="%PARSE_ARGV_ARG:~1,-1%"
      )
      SET PARSE_ARGV_ARG=[]
      SET PARSE_ARGV_INSIDE_QUOTES=FALSE
    )
    EXIT /B 0

:getarg
  SET %2=!ARG%1!
  SET %2_=!ARG%1_!
  SET %2Q=!ARG%1Q!
  EXIT /B 0

:getargs
  SET %3=
  FOR /L %%I IN (%1,1,%2) DO (
    IF %%I == %1 (
      SET %3=!ARG%%I!
    ) ELSE (
      SET %3=!%3! !ARG%%I!
    )
  )
  EXIT /B 0


:end



