/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.client.jersey;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.JwtBuilder;
import com.atlassian.asap.api.client.http.AuthorizationHeaderGenerator;
import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.api.exception.InvalidTokenException;
import com.atlassian.asap.core.client.http.AuthorizationHeaderGeneratorImpl;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
public class AsapAuthenticationFilter
implements ClientRequestFilter {
    @VisibleForTesting
    static final String CLIENT_ASAP_TOKEN_ERROR_MESSAGE = "Client failed to generate ASAP token.";
    private static final Logger log = LoggerFactory.getLogger(AsapAuthenticationFilter.class);
    private final Jwt prototype;
    private final AuthorizationHeaderGenerator authorizationHeaderGenerator;

    public AsapAuthenticationFilter(Jwt prototype, URI privateKeyPath) {
        this(prototype, AuthorizationHeaderGeneratorImpl.createDefault((URI)privateKeyPath));
    }

    public AsapAuthenticationFilter(Jwt prototype, AuthorizationHeaderGenerator authorizationHeaderGenerator) {
        this.prototype = Objects.requireNonNull(prototype);
        this.authorizationHeaderGenerator = Objects.requireNonNull(authorizationHeaderGenerator);
    }

    private String getAsapBearerToken() throws CannotRetrieveKeyException, InvalidTokenException {
        return this.authorizationHeaderGenerator.generateAuthorizationHeader(this.newJwtToken());
    }

    private Jwt newJwtToken() {
        Instant now = Instant.now();
        return JwtBuilder.copyJwt((Jwt)this.prototype).notBefore(Optional.of(now)).issuedAt(now).expirationTime(now.plus(JwtBuilder.DEFAULT_LIFETIME)).jwtId(UUID.randomUUID().toString()).build();
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (!requestContext.getHeaders().containsKey((Object)"Authorization")) {
            try {
                requestContext.getHeaders().add((Object)"Authorization", (Object)this.getAsapBearerToken());
            }
            catch (CannotRetrieveKeyException | InvalidTokenException ex) {
                log.error("Exception generating ASAP token.", ex);
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)CLIENT_ASAP_TOKEN_ERROR_MESSAGE).build());
            }
        }
    }
}

