/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.client.okhttp3;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.JwtBuilder;
import com.atlassian.asap.api.client.http.AuthorizationHeaderGenerator;
import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.api.exception.InvalidTokenException;
import com.atlassian.asap.core.client.okhttp3.AsapInterceptorException;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AsapInterceptor
implements Interceptor {
    private final Jwt jwtPrototype;
    private final AuthorizationHeaderGenerator authorizationHeaderGenerator;

    public AsapInterceptor(@Nonnull Jwt jwtPrototype, @Nonnull AuthorizationHeaderGenerator authorizationHeaderGenerator) {
        this.jwtPrototype = Objects.requireNonNull(jwtPrototype, "jwtPrototype");
        this.authorizationHeaderGenerator = Objects.requireNonNull(authorizationHeaderGenerator, "authorizationHeaderGenerator");
    }

    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (request.header("Authorization") != null) {
            return chain.proceed(request);
        }
        Jwt jwt = JwtBuilder.newFromPrototype((Jwt)this.jwtPrototype).build();
        String header = this.generateAuthorizationHeader(jwt);
        Request requestWithAuth = request.newBuilder().header("Authorization", header).build();
        return chain.proceed(requestWithAuth);
    }

    private String generateAuthorizationHeader(Jwt jwt) {
        try {
            return this.authorizationHeaderGenerator.generateAuthorizationHeader(jwt);
        }
        catch (CannotRetrieveKeyException | InvalidTokenException e) {
            throw new AsapInterceptorException("Exception generating ASAP authorization header in interceptor", e);
        }
    }
}

