/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.jersey;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

final class Memoizer<T, U> {
    private final Map<T, U> cache = new ConcurrentHashMap<T, U>();

    private Memoizer() {
    }

    private Function<T, U> doMemoize(Function<T, U> function) {
        return input -> this.cache.computeIfAbsent(input, function);
    }

    static <T, U> Function<T, U> memoize(Function<T, U> function) {
        return super.doMemoize(function);
    }
}

