/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.jersey;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.exception.AuthenticationFailedException;
import com.atlassian.asap.api.exception.PermanentAuthenticationFailedException;
import com.atlassian.asap.api.exception.TransientAuthenticationFailedException;
import com.atlassian.asap.api.server.http.RequestAuthenticator;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.server.AuthenticationContext;
import com.atlassian.asap.core.server.http.RequestAuthenticatorFactory;
import com.atlassian.asap.core.server.jersey.Asap;
import com.atlassian.asap.core.server.jersey.EmptyBodyFailureHandler;
import com.atlassian.asap.core.server.jersey.FailureHandler;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
public class AuthenticationRequestFilter
implements ContainerRequestFilter {
    static final int MAX_TRANSIENT_FAILURES_RETRIES = 10;
    static final String ASAP_REQUEST_ATTRIBUTE = "asap.annotation";
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationRequestFilter.class);
    @Context
    ResourceInfo resourceInfo;
    private final RequestAuthenticator authenticator;
    private final FailureHandler failureHandler;

    public AuthenticationRequestFilter(RequestAuthenticator authenticator, FailureHandler failureHandler) {
        this.failureHandler = Objects.requireNonNull(failureHandler);
        this.authenticator = Objects.requireNonNull(authenticator);
    }

    public void filter(ContainerRequestContext context) throws IOException {
        this.needsAuthentication().ifPresent(asap -> {
            context.setProperty("asap.authentic.jwt", (Object)this.authenticateToken(context));
            context.setProperty(ASAP_REQUEST_ATTRIBUTE, asap);
        });
    }

    @Nullable
    private Jwt authenticateToken(ContainerRequestContext context) {
        String authorizationHeader = context.getHeaderString("Authorization");
        for (int tryCounter = 0; tryCounter < 10; ++tryCounter) {
            try {
                Jwt authenticJwt = this.authenticator.authenticateRequest(authorizationHeader);
                LOG.trace("Accepting authentic token with identifier '{}'", (Object)authenticJwt.getClaims().getJwtId());
                return authenticJwt;
            }
            catch (TransientAuthenticationFailedException e) {
                if (tryCounter >= 9) {
                    this.failureHandler.onAuthenticationFailure(context, (AuthenticationFailedException)((Object)e));
                    return null;
                }
                boolean retry = this.failureHandler.onTransientAuthenticationFailure(context, e);
                if (retry) continue;
                return null;
            }
            catch (PermanentAuthenticationFailedException e) {
                this.failureHandler.onPermanentAuthenticationFailure(context, e);
                return null;
            }
            catch (AuthenticationFailedException e) {
                this.failureHandler.onAuthenticationFailure(context, e);
                return null;
            }
        }
        throw new IllegalStateException();
    }

    private Optional<Asap> needsAuthentication() {
        Asap asap = null;
        if (this.resourceInfo.getResourceMethod().isAnnotationPresent(Asap.class)) {
            asap = this.resourceInfo.getResourceMethod().getAnnotation(Asap.class);
        } else if (this.resourceInfo.getResourceClass().isAnnotationPresent(Asap.class)) {
            asap = this.resourceInfo.getResourceClass().getAnnotation(Asap.class);
        } else if (this.resourceInfo.getResourceClass().getPackage().isAnnotationPresent(Asap.class)) {
            asap = this.resourceInfo.getResourceClass().getPackage().getAnnotation(Asap.class);
        }
        return Optional.ofNullable(asap).filter(Asap::enabled);
    }

    public static AuthenticationRequestFilter newInstance(String audience, String repoUrl) {
        return AuthenticationRequestFilter.newInstance(new AuthenticationContext(audience, repoUrl));
    }

    public static AuthenticationRequestFilter newInstance(String audience, KeyProvider<PublicKey> keyProvider) {
        return AuthenticationRequestFilter.newInstance(new AuthenticationContext(audience, keyProvider));
    }

    public static AuthenticationRequestFilter newInstance(AuthenticationContext authenticationContext) {
        RequestAuthenticatorFactory requestAuthenticatorFactory = new RequestAuthenticatorFactory();
        RequestAuthenticator authenticator = requestAuthenticatorFactory.create(authenticationContext);
        return new AuthenticationRequestFilter(authenticator, new EmptyBodyFailureHandler());
    }
}

