/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.jersey;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.core.server.jersey.JwtParam;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

public class JwtParamBinder
extends AbstractBinder {
    protected void configure() {
        this.bind(JwtParamInjectResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<JwtParam>>(){}).in(Singleton.class);
        this.bind(JwtValueProvider.class).to(ValueFactoryProvider.class).in(Singleton.class);
    }

    private static class JwtValueProvider
    extends AbstractValueFactoryProvider {
        @Inject
        public JwtValueProvider(MultivaluedParameterExtractorProvider extractorProvider, ServiceLocator locator) {
            super(extractorProvider, locator, new Parameter.Source[]{Parameter.Source.UNKNOWN});
        }

        protected Factory<?> createValueFactory(Parameter parameter) {
            if (!parameter.isAnnotationPresent(JwtParam.class) || !Jwt.class.equals((Object)parameter.getRawType())) {
                return null;
            }
            return new JwtValueFactory();
        }
    }

    private static class JwtValueFactory
    extends AbstractContainerRequestValueFactory<Jwt> {
        private JwtValueFactory() {
        }

        public Jwt provide() {
            Object obj = this.getContainerRequest().getProperty("asap.authentic.jwt");
            return obj instanceof Jwt ? (Jwt)obj : null;
        }

        public void dispose(Jwt instance) {
        }
    }

    private static class JwtParamInjectResolver
    extends ParamInjectionResolver<JwtParam> {
        public JwtParamInjectResolver() {
            super(JwtValueProvider.class);
        }
    }
}

