/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.jersey;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.exception.AuthenticationFailedException;
import com.atlassian.asap.api.exception.PermanentAuthenticationFailedException;
import com.atlassian.asap.api.exception.TransientAuthenticationFailedException;
import com.atlassian.asap.api.server.http.RequestAuthenticator;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.server.AuthenticationContext;
import com.atlassian.asap.core.server.http.RequestAuthenticatorFactory;
import com.atlassian.asap.core.server.jersey.Asap;
import com.atlassian.asap.core.server.jersey.EmptyBodyFailureHandler;
import com.atlassian.asap.core.server.jersey.FailureHandler;
import com.atlassian.asap.core.server.jersey.JwtSecurityContextFactory;
import com.atlassian.asap.core.server.jersey.JwtSecurityContextFactoryImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.security.PublicKey;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
public class AuthenticationRequestFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationRequestFilter.class);
    @Context
    ResourceInfo resourceInfo;
    private final RequestAuthenticator authenticator;
    private final FailureHandler failureHandler;
    private final JwtSecurityContextFactory jwtSecurityContextFactory;

    public AuthenticationRequestFilter(RequestAuthenticator authenticator, FailureHandler failureHandler) {
        this(authenticator, failureHandler, new JwtSecurityContextFactoryImpl());
    }

    public AuthenticationRequestFilter(RequestAuthenticator authenticator, FailureHandler failureHandler, JwtSecurityContextFactory jwtSecurityContextFactory) {
        this.failureHandler = Objects.requireNonNull(failureHandler);
        this.authenticator = Objects.requireNonNull(authenticator);
        this.jwtSecurityContextFactory = Objects.requireNonNull(jwtSecurityContextFactory);
    }

    public void filter(ContainerRequestContext context) {
        this.mayNeedAuthentication().map(asap -> AuthenticationRequestFilter.setProperty(context, "asap.annotation", asap)).flatMap(asap -> this.authenticateToken(context, (Asap)asap)).map(authenticatedToken -> AuthenticationRequestFilter.setProperty(context, "asap.authentic.jwt", authenticatedToken)).ifPresent(authenticatedToken -> this.setSecurityContext(context, (Jwt)authenticatedToken));
    }

    private Optional<Jwt> authenticateToken(ContainerRequestContext context, Asap asap) {
        try {
            return AuthenticationRequestFilter.maybeGetAuthorizationHeader(context, asap).flatMap(header -> this.authenticateToken(context, (String)header));
        }
        catch (PermanentAuthenticationFailedException e) {
            this.failureHandler.onPermanentAuthenticationFailure(context, e);
            return Optional.empty();
        }
    }

    private static Optional<String> maybeGetAuthorizationHeader(ContainerRequestContext context, Asap asap) throws PermanentAuthenticationFailedException {
        String authorizationHeader = context.getHeaderString("Authorization");
        if (asap.mandatory() && authorizationHeader == null) {
            throw new PermanentAuthenticationFailedException("Authorization header is missing");
        }
        return Optional.ofNullable(authorizationHeader);
    }

    private Optional<Jwt> authenticateToken(ContainerRequestContext context, String authorizationHeader) {
        for (int tryCounter = 0; tryCounter < 10; ++tryCounter) {
            try {
                Jwt authenticJwt = this.authenticator.authenticateRequest(authorizationHeader);
                LOG.trace("Accepting authentic token with identifier '{}'", (Object)authenticJwt.getClaims().getJwtId());
                return Optional.of(authenticJwt);
            }
            catch (TransientAuthenticationFailedException e) {
                if (tryCounter >= 9) {
                    this.failureHandler.onAuthenticationFailure(context, (AuthenticationFailedException)((Object)e));
                    return Optional.empty();
                }
                boolean retry = this.failureHandler.onTransientAuthenticationFailure(context, e);
                if (retry) continue;
                return Optional.empty();
            }
            catch (PermanentAuthenticationFailedException e) {
                this.failureHandler.onPermanentAuthenticationFailure(context, e);
                return Optional.empty();
            }
            catch (AuthenticationFailedException e) {
                this.failureHandler.onAuthenticationFailure(context, e);
                return Optional.empty();
            }
        }
        throw new IllegalStateException();
    }

    private void setSecurityContext(ContainerRequestContext context, Jwt authenticatedToken) {
        context.setSecurityContext((SecurityContext)this.jwtSecurityContextFactory.createSecurityContext(authenticatedToken, context.getSecurityContext()));
    }

    private Optional<Asap> mayNeedAuthentication() {
        return AuthenticationRequestFilter.findFirstNonNullAnnotation(Asap.class, () -> this.resourceInfo.getResourceMethod(), () -> this.resourceInfo.getResourceClass(), () -> this.resourceInfo.getResourceClass().getPackage()).filter(Asap::enabled);
    }

    @SafeVarargs
    private static <A extends Annotation> Optional<A> findFirstNonNullAnnotation(Class<A> annotationClass, Supplier<? extends AnnotatedElement> ... annotatedElements) {
        return Stream.of(annotatedElements).map(Supplier::get).filter((? super T e) -> e.isAnnotationPresent(annotationClass)).map(e -> e.getAnnotation(annotationClass)).findFirst();
    }

    public static AuthenticationRequestFilter newInstance(String audience, String repoUrl) {
        return AuthenticationRequestFilter.newInstance(new AuthenticationContext(audience, repoUrl));
    }

    public static AuthenticationRequestFilter newInstance(String audience, KeyProvider<PublicKey> keyProvider) {
        return AuthenticationRequestFilter.newInstance(new AuthenticationContext(audience, keyProvider));
    }

    public static AuthenticationRequestFilter newInstance(AuthenticationContext authenticationContext) {
        RequestAuthenticatorFactory requestAuthenticatorFactory = new RequestAuthenticatorFactory();
        RequestAuthenticator authenticator = requestAuthenticatorFactory.create(authenticationContext);
        return new AuthenticationRequestFilter(authenticator, new EmptyBodyFailureHandler());
    }

    private static <T> T setProperty(ContainerRequestContext context, String name, T value) {
        context.setProperty(name, value);
        return value;
    }
}

