/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.jersey;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.exception.AuthorizationFailedException;
import com.atlassian.asap.core.server.jersey.Asap;
import com.atlassian.asap.core.server.jersey.AsapValidator;
import com.atlassian.asap.core.server.jersey.EmptyBodyFailureHandler;
import com.atlassian.asap.core.server.jersey.FailureHandler;
import java.util.Objects;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=2000)
public class AuthorizationRequestFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationRequestFilter.class);
    @Context
    ResourceInfo resourceInfo;
    private final FailureHandler failureHandler;
    private final AsapValidator asapValidator;

    public AuthorizationRequestFilter(FailureHandler failureHandler, AsapValidator asapValidator) {
        this.asapValidator = Objects.requireNonNull(asapValidator);
        this.failureHandler = Objects.requireNonNull(failureHandler);
    }

    public void filter(ContainerRequestContext context) {
        Jwt jwt = (Jwt)context.getProperty("asap.authentic.jwt");
        if (jwt != null) {
            Asap asap = (Asap)context.getProperty("asap.annotation");
            this.authorizeToken(context, jwt, asap);
        }
    }

    private void authorizeToken(ContainerRequestContext context, Jwt jwt, Asap asap) {
        try {
            this.asapValidator.validate(asap, jwt);
            LOG.trace("Accepting authorized token with identifier '{}'", (Object)jwt.getClaims().getJwtId());
        }
        catch (AuthorizationFailedException e) {
            this.failureHandler.onAuthorizationFailure(context, e);
        }
    }

    public static AuthorizationRequestFilter newInstance() {
        return new AuthorizationRequestFilter(new EmptyBodyFailureHandler(), AsapValidator.newAnnotationValidator());
    }
}

