/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.jersey;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.core.server.jersey.JwtSecurityContext;
import com.atlassian.asap.core.server.jersey.JwtSecurityContextFactory;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;
import org.apache.http.auth.BasicUserPrincipal;

public class JwtSecurityContextFactoryImpl
implements JwtSecurityContextFactory {
    @Override
    public JwtSecurityContext createSecurityContext(Jwt jwt, SecurityContext previousSecurityContext) {
        return new JwtSecurityContextImpl(jwt, previousSecurityContext.isSecure());
    }

    private static class JwtSecurityContextImpl
    implements JwtSecurityContext {
        private final Jwt jwt;
        private final boolean isSecure;

        JwtSecurityContextImpl(Jwt jwt, boolean isSecure) {
            this.jwt = jwt;
            this.isSecure = isSecure;
        }

        @Override
        public Jwt getJwt() {
            return this.jwt;
        }

        public Principal getUserPrincipal() {
            return new BasicUserPrincipal(this.jwt.getClaims().getSubject().orElse(this.jwt.getClaims().getIssuer()));
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return this.isSecure;
        }

        public String getAuthenticationScheme() {
            return "BASIC";
        }
    }
}

