/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.jersey;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.exception.AuthorizationFailedException;
import com.atlassian.asap.core.server.jersey.Asap;
import com.atlassian.asap.core.server.jersey.Memoizer;
import com.atlassian.asap.core.server.jersey.WhiteListAsapValidator;
import java.util.Set;

@FunctionalInterface
public interface AsapValidator {
    public void validate(Asap var1, Jwt var2) throws AuthorizationFailedException;

    default public AsapValidator andThen(AsapValidator then) {
        return (asap, jwt) -> {
            this.validate(asap, jwt);
            then.validate(asap, jwt);
        };
    }

    public static AsapValidator newAnnotationValidator() {
        return new WhiteListAsapValidator(Memoizer.memoize(new WhiteListAsapValidator.AsapWhitelistProvider()));
    }

    public static AsapValidator newEnvironmentVariablesValidator() {
        return new WhiteListAsapValidator(Memoizer.memoize(new WhiteListAsapValidator.EnvironmentVariablesWhitelistProvider()));
    }

    public static AsapValidator newAnnotationWithConfigValidator(Set<String> authorizedSubjects, Set<String> authorizedIssuers) {
        return new WhiteListAsapValidator(new WhiteListAsapValidator.AsapAnnotationWhitelistProviderWithConfigSupport(authorizedSubjects, authorizedIssuers));
    }
}

