/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.jersey;

import com.atlassian.asap.api.exception.AuthenticationFailedException;
import com.atlassian.asap.api.exception.AuthorizationFailedException;
import com.atlassian.asap.api.exception.PermanentAuthenticationFailedException;
import com.atlassian.asap.api.exception.TransientAuthenticationFailedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;

public interface FailureHandler {
    default public boolean onTransientAuthenticationFailure(ContainerRequestContext context, TransientAuthenticationFailedException e) {
        this.onAuthenticationFailure(context, (AuthenticationFailedException)((Object)e));
        return false;
    }

    default public void onPermanentAuthenticationFailure(ContainerRequestContext context, PermanentAuthenticationFailedException e) {
        this.onAuthenticationFailure(context, (AuthenticationFailedException)((Object)e));
    }

    default public void onAuthenticationFailure(ContainerRequestContext context, AuthenticationFailedException e) {
        context.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Bearer").build());
    }

    default public void onAuthorizationFailure(ContainerRequestContext context, AuthorizationFailedException e) {
        context.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
    }
}

