/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.jersey;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.exception.AuthorizationFailedException;
import com.atlassian.asap.core.server.jersey.Asap;
import com.atlassian.asap.core.server.jersey.AsapValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

final class WhiteListAsapValidator
implements AsapValidator {
    private final Function<Asap, Whitelist> whitelistProvider;

    WhiteListAsapValidator(Function<Asap, Whitelist> whitelistProvider) {
        this.whitelistProvider = Objects.requireNonNull(whitelistProvider);
    }

    private static String joinSet(Set<String> validIssuers) {
        return String.join((CharSequence)",", validIssuers);
    }

    @Override
    public void validate(Asap asap, Jwt jwt) throws AuthorizationFailedException {
        Whitelist whitelist = this.whitelistProvider.apply(asap);
        this.validateSubject(whitelist, jwt);
        this.validateIssuer(whitelist, jwt);
    }

    private void validateIssuer(Whitelist whitelist, Jwt jwt) throws AuthorizationFailedException {
        Set validIssuers;
        String issuer = jwt.getClaims().getIssuer();
        Set set = validIssuers = !whitelist.authorizedIssuers.isEmpty() ? whitelist.authorizedIssuers : whitelist.authorizedSubjects;
        if (!validIssuers.isEmpty() && !validIssuers.contains(issuer)) {
            throw new AuthorizationFailedException(String.format("Unacceptable issuer ('%s' not in '%s')", issuer, WhiteListAsapValidator.joinSet(validIssuers)));
        }
    }

    private void validateSubject(Whitelist whitelist, Jwt jwt) throws AuthorizationFailedException {
        String subject = jwt.getClaims().getSubject().orElse(jwt.getClaims().getIssuer());
        if (!whitelist.authorizedSubjects.isEmpty() && !whitelist.authorizedSubjects.contains(subject)) {
            throw new AuthorizationFailedException(String.format("Unacceptable subject ('%s' not in '%s')", subject, WhiteListAsapValidator.joinSet(whitelist.authorizedSubjects)));
        }
    }

    static class EnvironmentVariablesWhitelistProvider
    implements Function<Asap, Whitelist> {
        public static final String AUTHORIZED_SUBJECTS_KEY = "ASAP_AUTHORIZED_SUBJECTS";
        public static final String AUTHORIZED_ISSUERS_KEY = "ASAP_AUTHORIZED_ISSUERS";
        private final String authorizedSubjectsVariableName;
        private final String authorizedIssuersVariableName;
        private final Map<String, String> variables;

        EnvironmentVariablesWhitelistProvider() {
            this(AUTHORIZED_SUBJECTS_KEY, AUTHORIZED_ISSUERS_KEY, System.getenv());
        }

        EnvironmentVariablesWhitelistProvider(String authorizedSubjectsVariableName, String authorizedIssuersVariableName, Map<String, String> variables) {
            this.authorizedSubjectsVariableName = Objects.requireNonNull(authorizedSubjectsVariableName);
            this.authorizedIssuersVariableName = Objects.requireNonNull(authorizedIssuersVariableName);
            this.variables = variables;
        }

        @Override
        public Whitelist apply(Asap asap) {
            return new Whitelist(this.getEnv(this.authorizedSubjectsVariableName), this.getEnv(this.authorizedIssuersVariableName));
        }

        private Set<String> getEnv(String name) {
            return Stream.of(this.variables.getOrDefault(name, "").split(",")).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        }
    }

    static class AsapAnnotationWhitelistProviderWithConfigSupport
    implements Function<Asap, Whitelist> {
        private final Whitelist whiteList;

        AsapAnnotationWhitelistProviderWithConfigSupport(Set<String> authorizedSubjects, Set<String> authorizedIssuers) {
            this.whiteList = new Whitelist(authorizedSubjects, authorizedIssuers);
        }

        @Override
        public Whitelist apply(Asap asap) {
            if (asap.authorizedIssuers().length == 0 && asap.authorizedSubjects().length == 0) {
                return this.whiteList;
            }
            return new Whitelist(Arrays.stream(asap.authorizedSubjects()).collect(Collectors.toSet()), Arrays.stream(asap.authorizedIssuers()).collect(Collectors.toSet()));
        }
    }

    static class AsapWhitelistProvider
    implements Function<Asap, Whitelist> {
        AsapWhitelistProvider() {
        }

        @Override
        public Whitelist apply(Asap asap) {
            return new Whitelist(Arrays.stream(asap.authorizedSubjects()).collect(Collectors.toSet()), Arrays.stream(asap.authorizedIssuers()).collect(Collectors.toSet()));
        }
    }

    static class Whitelist {
        private final Set<String> authorizedSubjects;
        private final Set<String> authorizedIssuers;

        Whitelist(Set<String> authorizedSubjects, Set<String> authorizedIssuers) {
            this.authorizedSubjects = Collections.unmodifiableSet(Objects.requireNonNull(authorizedSubjects));
            this.authorizedIssuers = Collections.unmodifiableSet(Objects.requireNonNull(authorizedIssuers));
        }

        Set<String> getAuthorizedSubjects() {
            return this.authorizedSubjects;
        }

        Set<String> getAuthorizedIssuers() {
            return this.authorizedIssuers;
        }
    }
}

