package com.atlassian.bamboo.specs.api.builders.pbc;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.model.pbc.EnvProperties;
import com.atlassian.bamboo.specs.api.model.pbc.ExtraContainerProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
/**
 * Extra container defintion for PBC specs.
 */
public class ExtraContainer extends EntityPropertiesBuilder<ExtraContainerProperties> {
    
    private String name;
    private String image;
    private String size = "REGULAR";
    private List<EnvProperties> environments = new ArrayList<>();
    private List<String> commands = new ArrayList<>();
    
    public ExtraContainer() {
        
    }
    
    public ExtraContainer name(String name) {
        this.name = name;
        return this;
    }
    
    public ExtraContainer image(String image) {
        this.image = image;
        return this;
    }
    
    public ExtraContainer size(String size) {
        this.size = size;
        return this;
    }
    
    public ExtraContainer envVariables(EnvVar... environmentVariables) {
        envVariables(Arrays.asList(environmentVariables));
        return this;
    }
    
    public ExtraContainer envVariables(List<EnvVar> environmentVariables) {
        environmentVariables.stream().map(EnvVar::build)
                .forEach(this.environments::add);
        return this;
    }
    
    public ExtraContainer commands(String... commands) {
        commands(Arrays.asList(commands));
        return this;
    }
    
    public ExtraContainer commands(List<String> commands) {
        this.commands.addAll(commands);
        return this;
    }

    @Override
    protected ExtraContainerProperties build() {
        return new ExtraContainerProperties(name, image, size, environments, commands);
    }

    
    
}
