package com.atlassian.bamboo.specs.api.builders.pbc;

import com.atlassian.bamboo.specs.api.builders.deployment.configuration.EnvironmentPluginConfiguration;
import com.atlassian.bamboo.specs.api.model.pbc.ExtraContainerProperties;
import com.atlassian.bamboo.specs.api.model.pbc.PerBuildContainerForEnvironmentProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Per Build Container definition for Deployment Environments.
 */
public class PerBuildContainerForEnvironment 
        extends EnvironmentPluginConfiguration<PerBuildContainerForEnvironmentProperties> {


    private String image;
    private boolean enabled = true;
    private String size = "REGULAR";
    private List<ExtraContainerProperties> extraContainers = new ArrayList<>();
    
    public PerBuildContainerForEnvironment() {
    }
    
    public PerBuildContainerForEnvironment enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
    
    public PerBuildContainerForEnvironment image(String image) {
        this.image = image;
        return this;
    }
    
    public PerBuildContainerForEnvironment size(String size) {
        this.size = size;
        return this;
    }
    
    public PerBuildContainerForEnvironment extraContainers(ExtraContainer... extraContainers) {
        extraContainers(Arrays.asList(extraContainers));
        return this;
    }
    
    public PerBuildContainerForEnvironment extraContainers(List<ExtraContainer> extraContainers) {
        extraContainers.stream().map(ExtraContainer::build)
                .forEach(this.extraContainers::add);
        return this;
    }
    
    
    
    @Override
    protected PerBuildContainerForEnvironmentProperties build() {
        return new PerBuildContainerForEnvironmentProperties(enabled, image, size, extraContainers);
    }

    
}
