package com.atlassian.bamboo.specs.api.builders.pbc;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.PluginConfiguration;
import com.atlassian.bamboo.specs.api.model.pbc.ExtraContainerProperties;
import com.atlassian.bamboo.specs.api.model.pbc.PerBuildContainerForEnvironmentProperties;
import com.atlassian.bamboo.specs.api.model.pbc.PerBuildContainerForJobProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Per Build Container definition for Bamboo Jobs.
 */
public class PerBuildContainerForJob extends PluginConfiguration<PerBuildContainerForJobProperties> {


    private String image;
    private boolean enabled = true;
    private String size = "REGULAR";
    private List<ExtraContainerProperties> extraContainers = new ArrayList<>();
    
    public PerBuildContainerForJob() {
    }
    
    public PerBuildContainerForJob enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
    
    public PerBuildContainerForJob image(String image) {
        this.image = image;
        return this;
    }
    
    public PerBuildContainerForJob size(String size) {
        this.size = size;
        return this;
    }
    
    public PerBuildContainerForJob extraContainers(ExtraContainer... extraContainers) {
        extraContainers(Arrays.asList(extraContainers));
        return this;
    }
    
    public PerBuildContainerForJob extraContainers(List<ExtraContainer> extraContainers) {
        extraContainers.stream().map(ExtraContainer::build)
                .forEach(this.extraContainers::add);
        return this;
    }
    
    
    @Override
    protected PerBuildContainerForJobProperties build() {
        return new PerBuildContainerForJobProperties(enabled, image, size, extraContainers);
    }

    
}
