/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.pbc;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.pbc.EnvVar;
import com.atlassian.bamboo.specs.api.model.pbc.EnvProperties;
import com.atlassian.bamboo.specs.api.model.pbc.ExtraContainerProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExtraContainer
extends EntityPropertiesBuilder<ExtraContainerProperties> {
    private String name;
    private String image;
    private String size = "REGULAR";
    private List<EnvProperties> environments = new ArrayList<EnvProperties>();
    private List<String> commands = new ArrayList<String>();

    public ExtraContainer name(String name) {
        this.name = name;
        return this;
    }

    public ExtraContainer image(String image) {
        this.image = image;
        return this;
    }

    public ExtraContainer size(String size) {
        this.size = size;
        return this;
    }

    public ExtraContainer envVariables(EnvVar ... environmentVariables) {
        this.envVariables(Arrays.asList(environmentVariables));
        return this;
    }

    public ExtraContainer envVariables(List<EnvVar> environmentVariables) {
        environmentVariables.stream().map(EnvVar::build).forEach(this.environments::add);
        return this;
    }

    public ExtraContainer commands(String ... commands) {
        this.commands(Arrays.asList(commands));
        return this;
    }

    public ExtraContainer commands(List<String> commands) {
        this.commands.addAll(commands);
        return this;
    }

    protected ExtraContainerProperties build() {
        return new ExtraContainerProperties(this.name, this.image, this.size, this.environments, this.commands);
    }
}

