/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.pbc;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.pbc.ContainerSize;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.pbc.ExtraContainerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

class AbstractPerBuildContainerProperties {
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Per-Build Container (PBC)");
    private List<ExtraContainerProperties> extraContainers;
    private String size;
    private String image;
    private boolean enabled;
    protected final AtlassianModuleProperties module;

    protected AbstractPerBuildContainerProperties(AtlassianModule module) {
        this.module = (AtlassianModuleProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)module);
    }

    public AbstractPerBuildContainerProperties(AtlassianModule module, boolean enabled, String image, String size, List<ExtraContainerProperties> extraContainers) {
        this(module);
        this.enabled = enabled;
        this.image = image;
        this.size = size != null ? size.toUpperCase(Locale.ENGLISH) : null;
        this.extraContainers = extraContainers;
        this.validate();
    }

    public List<ExtraContainerProperties> getExtraContainers() {
        return this.extraContainers;
    }

    public String getSize() {
        return this.size;
    }

    public String getImage() {
        return this.image;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public final void validate() {
        if (this.enabled) {
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"image", (String)this.image);
            ImporterUtils.checkArgument((ValidationContext)VALIDATION_CONTEXT, (this.image != null && StringUtils.deleteWhitespace((String)this.image).equals(this.image) ? 1 : 0) != 0, (Object)("Argument 'image' cannot contain whitespace ('" + this.image + "')."));
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"size", (String)this.size);
            ImporterUtils.checkArgument((ValidationContext)VALIDATION_CONTEXT, (boolean)Stream.of(ContainerSize.values()).anyMatch(t -> t.name().equals(this.size)), (Object)("Container size is to be one of " + Arrays.toString((Object[])ContainerSize.values())));
            ImporterUtils.checkNotNull((ValidationContext)VALIDATION_CONTEXT, (String)"extraContainers", this.extraContainers);
            if (this.extraContainers != null) {
                this.extraContainers.forEach(t -> t.validate());
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.image, this.size, this.extraContainers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPerBuildContainerProperties other = (AbstractPerBuildContainerProperties)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (!Objects.equals(this.size, other.size)) {
            return false;
        }
        if (!Objects.equals(this.image, other.image)) {
            return false;
        }
        return Objects.equals(this.extraContainers, other.extraContainers);
    }
}

