package com.atlassian.bamboo.specs.api.builders.pbc;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.model.pbc.EnvProperties;
import com.atlassian.bamboo.specs.api.model.pbc.ExtraContainerProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Extra container definition for PBC specs.
 */
public class ExtraContainer extends EntityPropertiesBuilder<ExtraContainerProperties> {
    
    private String name;
    private String image;
    private String size = ExtraContainerSize.REGULAR.name();
    private List<EnvProperties> environments = new ArrayList<>();
    private List<String> commands = new ArrayList<>();
    
    public ExtraContainer() {
        
    }
    
    public ExtraContainer name(String name) {
        this.name = name;
        return this;
    }
    
    public ExtraContainer image(String image) {
        this.image = image;
        return this;
    }

    /**
     * Symbolic name for size of the extra container.
     * See ExtraContainerSize enum for allowed values.
     * The default value is 'REGULAR'.
     */
    public ExtraContainer size(String size) {
        this.size = size;
        return this;
    }
    
    /**
     * Symbolic name for size of the extra container.
     * The default value is 'REGULAR'.
     */
    public ExtraContainer size(ExtraContainerSize size) {
        this.size = size != null ? size.name() : null;
        return this;
    }
    
    public ExtraContainer envVariables(EnvVar... environmentVariables) {
        envVariables(Arrays.asList(environmentVariables));
        return this;
    }
    
    public ExtraContainer envVariables(List<EnvVar> environmentVariables) {
        environmentVariables.stream().map(EnvVar::build)
                .forEach(this.environments::add);
        return this;
    }
    
    public ExtraContainer commands(String... commands) {
        commands(Arrays.asList(commands));
        return this;
    }
    
    public ExtraContainer commands(List<String> commands) {
        this.commands.addAll(commands);
        return this;
    }

    @Override
    protected ExtraContainerProperties build() {
        return new ExtraContainerProperties(name, image, size, environments, commands);
    }

    
    
}
