package com.atlassian.bamboo.specs.api.builders.pbc;

import com.atlassian.bamboo.specs.api.builders.deployment.configuration.EnvironmentPluginConfiguration;
import com.atlassian.bamboo.specs.api.model.pbc.ExtraContainerProperties;
import com.atlassian.bamboo.specs.api.model.pbc.PerBuildContainerForEnvironmentProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Per Build Container definition for Deployment Environments.
 */
public class PerBuildContainerForEnvironment 
        extends EnvironmentPluginConfiguration<PerBuildContainerForEnvironmentProperties> {


    private String image;
    private boolean enabled = true;
    private String size = ContainerSize.REGULAR.name();
    private String awsRole;
    private List<ExtraContainerProperties> extraContainers = new ArrayList<>();
    
    public PerBuildContainerForEnvironment() {
    }

    /**
     * Marks PBC as enabled for given job. Default value is true.
     */
    public PerBuildContainerForEnvironment enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
    
    public PerBuildContainerForEnvironment image(String image) {
        this.image = image;
        return this;
    }
    /**
     * Symbolic name for size of the container.
     * See ContainerSize enum for allowed values.
     * The default value is 'REGULAR'.
     */
    public PerBuildContainerForEnvironment size(String size) {
        this.size = size;
        return this;
    }
    
    /**
     * Symbolic name for size of the container.
     * The default value is 'REGULAR'.
     */
    public PerBuildContainerForEnvironment size(ContainerSize size) {
        this.size = size != null ? size.name() : null;
        return this;
    }
    
    /**
     * AWS Role of the current deployment.
     * Optional. Needs to be supported by the runtime environment.
     */
    public PerBuildContainerForEnvironment awsRole(String awsRole) {
        this.awsRole = awsRole;
        return this;
    }
    
    public PerBuildContainerForEnvironment extraContainers(ExtraContainer... extraContainers) {
        extraContainers(Arrays.asList(extraContainers));
        return this;
    }
    
    public PerBuildContainerForEnvironment extraContainers(List<ExtraContainer> extraContainers) {
        extraContainers.stream().map(ExtraContainer::build)
                .forEach(this.extraContainers::add);
        return this;
    }
    
    @Override
    protected PerBuildContainerForEnvironmentProperties build() {
        return new PerBuildContainerForEnvironmentProperties(enabled, image, size, extraContainers, awsRole);
    }

}
