/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.pbc;

import com.atlassian.bamboo.specs.api.builders.pbc.Architecture;
import com.atlassian.bamboo.specs.api.builders.pbc.ContainerSize;
import com.atlassian.bamboo.specs.api.builders.pbc.ExtraContainer;
import com.atlassian.bamboo.specs.api.builders.pbc.ExtraContainerSize;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.model.pbc.ExtraContainerProperties;
import com.atlassian.bamboo.specs.codegen.emitters.pbc.PerBuildContainerForEnvironmentEmitter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;

public class EmitterUtils {
    static String version() {
        try {
            Properties props = new Properties();
            InputStream stream = PerBuildContainerForEnvironmentEmitter.class.getResourceAsStream("/com/atlassian/bamboo/specs/codegen/emitters/pbc/version.properties");
            if (stream != null) {
                props.load(stream);
            }
            return props.getProperty("version", "RELEASE");
        }
        catch (IOException ex) {
            return "RELEASE";
        }
    }

    static String toJson(List<ExtraContainerProperties> extraContainers) {
        return "[" + extraContainers.stream().map(t -> {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("\\\"name\\\":\\\"").append(t.getName()).append("\\\"");
            sb.append(",\\\"image\\\":\\\"").append(t.getImage()).append("\\\"");
            sb.append(",\\\"size\\\":\\\"").append(t.getSize()).append("\\\"");
            if (!t.getCommands().isEmpty()) {
                sb.append(",\\\"commands\\\": [").append(t.getCommands().stream().map(t1 -> "\\\"" + EmitterUtils.escapeJson(t1) + "\\\"").collect(Collectors.joining(","))).append("]");
            }
            if (!t.getEnvironments().isEmpty()) {
                sb.append(",\\\"envVars\\\":[").append(t.getEnvironments().stream().map(t1 -> "{\\\"name\\\":\\\"" + EmitterUtils.escapeJson(t1.getKey()) + "\\\",\\\"value\\\":\\\"" + EmitterUtils.escapeJson(t1.getValue()) + "\\\"}").collect(Collectors.joining(","))).append("]");
            }
            sb.append("}");
            return sb.toString();
        }).collect(Collectors.joining(",")) + "]";
    }

    private static String escapeJson(String t) {
        return StringEscapeUtils.escapeJson((String)t);
    }

    private static String escapeJava(String t) {
        return StringEscapeUtils.escapeJava((String)t);
    }

    static void generateExtraContainerBuilder(List<ExtraContainerProperties> extras, StringBuilder sb, CodeGenerationContext context) {
        if (!extras.isEmpty()) {
            sb.append(context.newLine()).append(".extraContainers(");
            context.incIndentation();
            sb.append(extras.stream().map(t -> {
                StringBuilder sb2 = new StringBuilder();
                sb2.append(context.newLine()).append("new ").append(ExtraContainer.class.getSimpleName()).append("()");
                context.incIndentation();
                sb2.append(context.newLine()).append(".name(\"").append(t.getName()).append("\")");
                sb2.append(context.newLine()).append(".image(\"").append(t.getImage()).append("\")");
                sb2.append(context.newLine()).append(".size(").append(EmitterUtils.generateExtraSizeEnumOrString(t.getSize())).append(")");
                if (!t.getCommands().isEmpty()) {
                    sb2.append(context.newLine()).append(".commands(").append(t.getCommands().stream().map(t1 -> "\"" + EmitterUtils.escapeJava(t1) + "\"").collect(Collectors.joining(","))).append(")");
                }
                if (!t.getEnvironments().isEmpty()) {
                    sb2.append(context.newLine()).append(".envVariables(").append(t.getEnvironments().stream().map(t1 -> "new EnvVar(\"" + EmitterUtils.escapeJava(t1.getKey()) + "\", \"" + EmitterUtils.escapeJava(t1.getValue()) + "\")").collect(Collectors.joining(", "))).append(")");
                }
                context.decIndentation();
                return sb2.toString();
            }).collect(Collectors.joining(", ")));
            context.decIndentation();
            sb.append(context.newLine()).append(")");
        }
    }

    static String generateSizeEnumOrString(String size) {
        try {
            ContainerSize.valueOf(size);
            return "ContainerSize." + size;
        }
        catch (IllegalArgumentException exc) {
            return "\"" + size + "\"";
        }
    }

    private static String generateExtraSizeEnumOrString(String size) {
        try {
            ExtraContainerSize.valueOf(size);
            return "ExtraContainerSize." + size;
        }
        catch (IllegalArgumentException exc) {
            return "\"" + size + "\"";
        }
    }

    static String generateArchitectureEnumOrString(String archString) {
        try {
            Architecture arch = Architecture.fromString(archString);
            return "Architecture." + arch.name();
        }
        catch (IllegalArgumentException e) {
            return "\"" + archString + "\"";
        }
    }
}

