package com.atlassian.bamboo.specs.codegen.emitters.pbc;

import com.atlassian.bamboo.specs.api.builders.pbc.PerBuildContainerForJob;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.AllOtherPluginsConfiguration;
import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.pbc.PerBuildContainerForJobProperties;
import com.atlassian.bamboo.specs.util.MapBuilder;
import org.jetbrains.annotations.NotNull;

public class PerBuildContainerForJobEmitter implements CodeEmitter<PerBuildContainerForJobProperties> {

    @NotNull
    @Override
    public String emitCode(@NotNull final CodeGenerationContext context,
            @NotNull final PerBuildContainerForJobProperties entity) throws CodeGenerationException {
        if (!entity.isEnabled()) {
            return "";
        }
        context.importClassName(AllOtherPluginsConfiguration.class);
        StringBuilder sb = new StringBuilder();
        sb.append(context.newLine());
        sb.append("/* Add com.atlassian.buildeng:bamboo-pbc-specs:").append(EmitterUtils.version())
                .append(" as dependency to your specs pom.xml to make use of this custom entity.");
        sb.append(context.newLine());

        appendDslClass(sb, entity, context);

        context.importClassName(AllOtherPluginsConfiguration.class);
        context.importClassName(MapBuilder.class);
        sb.append("new ").append(AllOtherPluginsConfiguration.class.getSimpleName()).append("()");
        context.incIndentation();
        sb.append(context.newLine()).append(".configuration(new MapBuilder()");
        context.incIndentation();
        sb.append(context.newLine()).append(".put(\"custom.isolated.docker\", new MapBuilder()");
        context.incIndentation();
        sb.append(context.newLine()).append(".put(\"enabled\", \"").append(entity.isEnabled()).append("\")");
        sb.append(context.newLine()).append(".put(\"image\", \"").append(entity.getImage()).append("\")");
        sb.append(context.newLine()).append(".put(\"imageSize\", \"").append(entity.getSize()).append("\")");
        if (entity.getAwsRole() != null) {
            sb.append(context.newLine()).append(".put(\"awsRole\", \"").append(entity.getAwsRole()).append("\")");
        }
        if (entity.getArchitecture() != null) {
            sb.append(context.newLine()).append(".put(\"architecture\", \"").append(entity.getArchitecture()).append("\")");
        }
        if (!entity.getExtraContainers().isEmpty()) {
            sb.append(context.newLine()).append(".put(\"extraContainers\", \"")
                    .append(EmitterUtils.toJson(entity.getExtraContainers())).append("\")");
        }
        if (!entity.getFeatureFlags().isEmpty()) {
            sb.append(context.newLine()).append(".put(\"custom.isolated.docker.featureFlags\", \"")
                    .append(EmitterUtils.toJson(entity.getFeatureFlags())).append("\")");
        }
        sb.append(context.newLine()).append(".build())");
        context.decIndentation();
        sb.append(context.newLine()).append(".build())");
        context.decIndentation();
        context.decIndentation();
        return sb.toString();
    }

    private void appendDslClass(StringBuilder sb, PerBuildContainerForJobProperties entity,
            CodeGenerationContext context) {
        sb.append("new ").append(PerBuildContainerForJob.class.getSimpleName()).append("()");
        dslParams(context, sb, entity);
    }

    private void dslParams(CodeGenerationContext context, StringBuilder sb, PerBuildContainerForJobProperties entity) {
        context.incIndentation();
        if (!entity.isEnabled()) {
            sb.append(context.newLine()).append(".enabled(").append(entity.isEnabled()).append(")");
        }
        sb.append(context.newLine()).append(".image(\"").append(entity.getImage()).append("\")");
        sb.append(context.newLine()).append(".size(")
                .append(EmitterUtils.generateSizeEnumOrString(entity.getSize())).append(")");
        if (entity.getAwsRole() != null) {
            sb.append(context.newLine()).append(".awsRole(\"").append(entity.getAwsRole()).append("\")");
        }
        if (entity.getArchitecture() != null) {
            sb.append(context.newLine()).append(".architecture(")
                    .append(EmitterUtils.generateArchitectureEnumOrString(entity.getArchitecture())).append(")");
        }
        EmitterUtils.generateExtraContainerBuilder(entity.getExtraContainers(), sb, context);
        context.decIndentation();
        sb.append(" */").append(context.newLine());
    }


}
