/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.pbc;

import com.atlassian.bamboo.specs.api.builders.pbc.Architecture;
import com.atlassian.bamboo.specs.api.builders.pbc.ContainerSize;
import com.atlassian.bamboo.specs.api.builders.pbc.ExtraContainer;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.PluginConfiguration;
import com.atlassian.bamboo.specs.api.model.pbc.ExtraContainerProperties;
import com.atlassian.bamboo.specs.api.model.pbc.PerBuildContainerForJobProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class PerBuildContainerForJob
extends PluginConfiguration<PerBuildContainerForJobProperties> {
    private String image;
    private boolean enabled = true;
    private String size = ContainerSize.REGULAR.name();
    private String awsRole;
    private String architecture;
    private List<ExtraContainerProperties> extraContainers = new ArrayList<ExtraContainerProperties>();
    private HashSet<String> featureFlags = new HashSet();

    public PerBuildContainerForJob enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public PerBuildContainerForJob image(String image) {
        this.image = image;
        return this;
    }

    public PerBuildContainerForJob withFeatureFlag(String featureFlag) {
        this.featureFlags.add(featureFlag);
        return this;
    }

    public PerBuildContainerForJob withFeatureFlags(HashSet<String> featureFlags) {
        this.featureFlags.addAll(featureFlags);
        return this;
    }

    public PerBuildContainerForJob size(String size) {
        this.size = size;
        return this;
    }

    public PerBuildContainerForJob size(ContainerSize size) {
        this.size = size != null ? size.name() : null;
        return this;
    }

    public PerBuildContainerForJob awsRole(String awsRole) {
        this.awsRole = awsRole;
        return this;
    }

    public PerBuildContainerForJob architecture(Architecture architecture) {
        this.architecture = architecture.toString();
        return this;
    }

    @Deprecated
    public PerBuildContainerForJob architecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public PerBuildContainerForJob extraContainers(ExtraContainer ... extraContainers) {
        this.extraContainers(Arrays.asList(extraContainers));
        return this;
    }

    public PerBuildContainerForJob extraContainers(List<ExtraContainer> extraContainers) {
        extraContainers.stream().map(ExtraContainer::build).forEach(this.extraContainers::add);
        return this;
    }

    protected PerBuildContainerForJobProperties build() {
        return new PerBuildContainerForJobProperties(this.enabled, this.image, this.size, this.extraContainers, this.awsRole, this.architecture, this.featureFlags);
    }
}

