/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.pbc;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.pbc.ContainerSize;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.pbc.ExtraContainerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

class AbstractPerBuildContainerProperties {
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Per-Build Container (PBC)");
    private List<ExtraContainerProperties> extraContainers;
    private String size;
    private String image;
    private boolean enabled;
    protected final AtlassianModuleProperties module;
    private String awsRole;
    private String architecture;
    private HashSet<String> featureFlags;

    protected AbstractPerBuildContainerProperties(AtlassianModule module) {
        this.module = (AtlassianModuleProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)module);
    }

    public AbstractPerBuildContainerProperties(AtlassianModule module, boolean enabled, String image, String size, List<ExtraContainerProperties> extraContainers, String awsRole, String architecture, HashSet<String> featureFlags) {
        this(module);
        this.enabled = enabled;
        this.image = image;
        this.size = size != null ? size.toUpperCase(Locale.ENGLISH) : null;
        this.extraContainers = extraContainers;
        this.awsRole = awsRole;
        this.architecture = architecture;
        this.featureFlags = featureFlags;
        this.validate();
    }

    public List<ExtraContainerProperties> getExtraContainers() {
        return this.extraContainers;
    }

    public String getSize() {
        return this.size;
    }

    public String getImage() {
        return this.image;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getAwsRole() {
        return this.awsRole;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public HashSet<String> getFeatureFlags() {
        return this.featureFlags;
    }

    public final void validate() {
        if (this.enabled) {
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"image", (String)this.image);
            ImporterUtils.checkArgument((ValidationContext)VALIDATION_CONTEXT, (this.image != null && StringUtils.deleteWhitespace((String)this.image).equals(this.image) ? 1 : 0) != 0, (Object)("Argument 'image' cannot contain whitespace ('" + this.image + "')."));
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"size", (String)this.size);
            ImporterUtils.checkArgument((ValidationContext)VALIDATION_CONTEXT, (boolean)Stream.of(ContainerSize.values()).anyMatch(t -> t.name().equals(this.size)), (Object)("Container size is to be one of " + Arrays.toString((Object[])ContainerSize.values())));
            ImporterUtils.checkNotNull((ValidationContext)VALIDATION_CONTEXT, (String)"extraContainers", this.extraContainers);
            if (this.extraContainers != null) {
                this.extraContainers.forEach(t -> t.validate());
            }
            if (this.awsRole != null) {
                ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"awsRole", (String)this.awsRole);
                ImporterUtils.checkArgument((ValidationContext)VALIDATION_CONTEXT, (boolean)Pattern.compile("arn:aws:iam::[0-9]+:role/[a-zA-Z0-9+=,.@_\\-]+").matcher(this.awsRole).matches(), (Object)"Format of IAM role ARN is wrong.");
            }
            if (this.architecture != null) {
                ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"architecture", (String)this.architecture);
            }
            if (this.featureFlags != null) {
                this.featureFlags.forEach(featureFlag -> ImporterUtils.checkArgument((ValidationContext)VALIDATION_CONTEXT, (boolean)Pattern.compile("[a-zA-Z0-9_-]+").matcher((CharSequence)featureFlag).matches(), (Object)"Feature flag includes invalid characters"));
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.image, this.size, this.extraContainers, this.awsRole, this.architecture, this.featureFlags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPerBuildContainerProperties other = (AbstractPerBuildContainerProperties)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (!Objects.equals(this.size, other.size)) {
            return false;
        }
        if (!Objects.equals(this.image, other.image)) {
            return false;
        }
        if (!Objects.equals(this.awsRole, other.awsRole)) {
            return false;
        }
        if (!Objects.equals(this.architecture, other.architecture)) {
            return false;
        }
        if (!Objects.equals(this.extraContainers, other.extraContainers)) {
            return false;
        }
        return Objects.equals(this.featureFlags, other.featureFlags);
    }
}

