package com.atlassian.bamboo.specs.api.builders.pbc;

public enum Architecture {
    X86_64("amd64"),
    ARM64("arm64");

    private final String key;

    Architecture(String value) {
        this.key = value;
    }

    @Override
    public String toString() {
        return this.key;
    }

    // We will want to generate the enum values for specs, since the final config object actually stores them as
    // strings,
    // we will need to re-convert them back
    public static Architecture fromString(String text) {
        for (Architecture arch : Architecture.values()) {
            if (arch.key.equalsIgnoreCase(text)) {
                return arch;
            }
        }
        throw new IllegalArgumentException("No value with key '" + text + "' was found.");
    }
}
