package com.atlassian.bamboo.specs.api.builders.pbc;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.model.pbc.EnvProperties;

/**
 * Environment variable definition for PBC extra container specs.
 */
public class EnvVar extends EntityPropertiesBuilder<EnvProperties> {

    private String key;
    private String value;

    public EnvVar() {}

    public EnvVar(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public EnvVar key(String key) {
        this.key = key;
        return this;
    }

    public EnvVar value(String value) {
        this.value = value;
        return this;
    }

    @Override
    protected EnvProperties build() {
        return new EnvProperties(key, value);
    }
}
